/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.spdy;

import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelDownstreamHandler;
import shaded.netty.channel.ChannelEvent;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.channel.ChannelStateEvent;
import shaded.netty.channel.Channels;
import shaded.netty.channel.MessageEvent;
import shaded.netty.handler.codec.frame.FrameDecoder;
import shaded.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import shaded.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import shaded.netty.handler.codec.spdy.SpdyDataFrame;
import shaded.netty.handler.codec.spdy.SpdyFrameDecoder;
import shaded.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import shaded.netty.handler.codec.spdy.SpdyFrameEncoder;
import shaded.netty.handler.codec.spdy.SpdyGoAwayFrame;
import shaded.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import shaded.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import shaded.netty.handler.codec.spdy.SpdyHeadersFrame;
import shaded.netty.handler.codec.spdy.SpdyPingFrame;
import shaded.netty.handler.codec.spdy.SpdyProtocolException;
import shaded.netty.handler.codec.spdy.SpdyRstStreamFrame;
import shaded.netty.handler.codec.spdy.SpdySettingsFrame;
import shaded.netty.handler.codec.spdy.SpdySynReplyFrame;
import shaded.netty.handler.codec.spdy.SpdySynStreamFrame;
import shaded.netty.handler.codec.spdy.SpdyVersion;
import shaded.netty.handler.codec.spdy.SpdyWindowUpdateFrame;

public class SpdyFrameCodec
extends FrameDecoder
implements SpdyFrameDecoderDelegate,
ChannelDownstreamHandler {
    private static final SpdyProtocolException INVALID_FRAME = new SpdyProtocolException("Received invalid frame");
    private final SpdyFrameDecoder spdyFrameDecoder;
    private final SpdyFrameEncoder spdyFrameEncoder;
    private final SpdyHeaderBlockDecoder spdyHeaderBlockDecoder;
    private final SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
    private SpdyHeadersFrame spdyHeadersFrame;
    private SpdySettingsFrame spdySettingsFrame;
    private volatile ChannelHandlerContext ctx;

    public SpdyFrameCodec(SpdyVersion version) {
        this(version, 8192, 16384, 6, 15, 8);
    }

    public SpdyFrameCodec(SpdyVersion version, int maxChunkSize, int maxHeaderSize, int compressionLevel, int windowBits, int memLevel) {
        this(version, maxChunkSize, SpdyHeaderBlockDecoder.newInstance(version, maxHeaderSize), SpdyHeaderBlockEncoder.newInstance(version, compressionLevel, windowBits, memLevel));
    }

    protected SpdyFrameCodec(SpdyVersion version, int maxChunkSize, SpdyHeaderBlockDecoder spdyHeaderBlockDecoder, SpdyHeaderBlockEncoder spdyHeaderBlockEncoder) {
        this.spdyFrameDecoder = new SpdyFrameDecoder(version, this, maxChunkSize);
        this.spdyFrameEncoder = new SpdyFrameEncoder(version);
        this.spdyHeaderBlockDecoder = spdyHeaderBlockDecoder;
        this.spdyHeaderBlockEncoder = spdyHeaderBlockEncoder;
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        super.beforeAdd(ctx);
        this.ctx = ctx;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        this.spdyFrameDecoder.decode(buffer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
        try {
            super.cleanup(ctx, e);
            Object var4_3 = null;
            this.spdyHeaderBlockDecoder.end();
            spdyHeaderBlockEncoder = this.spdyHeaderBlockEncoder;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.spdyHeaderBlockDecoder.end();
            SpdyHeaderBlockEncoder spdyHeaderBlockEncoder2 = this.spdyHeaderBlockEncoder;
            synchronized (spdyHeaderBlockEncoder2) {
                this.spdyHeaderBlockEncoder.end();
            }
            throw throwable;
        }
        synchronized (spdyHeaderBlockEncoder) {
            this.spdyHeaderBlockEncoder.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    SpdyHeaderBlockEncoder spdyHeaderBlockEncoder = this.spdyHeaderBlockEncoder;
                    synchronized (spdyHeaderBlockEncoder) {
                        this.spdyHeaderBlockEncoder.end();
                        break;
                    }
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodeDataFrame(spdyDataFrame.getStreamId(), spdyDataFrame.isLast(), spdyDataFrame.getData());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdySynStreamFrame) {
            SpdyHeaderBlockEncoder spdyDataFrame = this.spdyHeaderBlockEncoder;
            synchronized (spdyDataFrame) {
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
                ChannelBuffer frame = this.spdyFrameEncoder.encodeSynStreamFrame(spdySynStreamFrame.getStreamId(), spdySynStreamFrame.getAssociatedToStreamId(), spdySynStreamFrame.getPriority(), spdySynStreamFrame.isLast(), spdySynStreamFrame.isUnidirectional(), this.spdyHeaderBlockEncoder.encode(spdySynStreamFrame));
                Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdySynReplyFrame) {
            SpdyHeaderBlockEncoder spdyDataFrame = this.spdyHeaderBlockEncoder;
            synchronized (spdyDataFrame) {
                SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
                ChannelBuffer frame = this.spdyFrameEncoder.encodeSynReplyFrame(spdySynReplyFrame.getStreamId(), spdySynReplyFrame.isLast(), this.spdyHeaderBlockEncoder.encode(spdySynReplyFrame));
                Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodeRstStreamFrame(spdyRstStreamFrame.getStreamId(), spdyRstStreamFrame.getStatus().getCode());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodeSettingsFrame(spdySettingsFrame);
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodePingFrame(spdyPingFrame.getId());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodeGoAwayFrame(spdyGoAwayFrame.getLastGoodStreamId(), spdyGoAwayFrame.getStatus().getCode());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyHeadersFrame) {
            SpdyHeaderBlockEncoder spdyGoAwayFrame = this.spdyHeaderBlockEncoder;
            synchronized (spdyGoAwayFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                ChannelBuffer frame = this.spdyFrameEncoder.encodeHeadersFrame(spdyHeadersFrame.getStreamId(), spdyHeadersFrame.isLast(), this.spdyHeaderBlockEncoder.encode(spdyHeadersFrame));
                Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
            ChannelBuffer frame = this.spdyFrameEncoder.encodeWindowUpdateFrame(spdyWindowUpdateFrame.getStreamId(), spdyWindowUpdateFrame.getDeltaWindowSize());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        ctx.sendDownstream(evt);
    }

    public void readDataFrame(int streamId, boolean last, ChannelBuffer data) {
        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
        spdyDataFrame.setLast(last);
        spdyDataFrame.setData(data);
        Channels.fireMessageReceived(this.ctx, (Object)spdyDataFrame);
    }

    public void readSynStreamFrame(int streamId, int associatedToStreamId, byte priority, boolean last, boolean unidirectional) {
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, associatedToStreamId, priority);
        spdySynStreamFrame.setLast(last);
        spdySynStreamFrame.setUnidirectional(unidirectional);
        this.spdyHeadersFrame = spdySynStreamFrame;
    }

    public void readSynReplyFrame(int streamId, boolean last) {
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
        spdySynReplyFrame.setLast(last);
        this.spdyHeadersFrame = spdySynReplyFrame;
    }

    public void readRstStreamFrame(int streamId, int statusCode) {
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, statusCode);
        Channels.fireMessageReceived(this.ctx, (Object)spdyRstStreamFrame);
    }

    public void readSettingsFrame(boolean clearPersisted) {
        this.spdySettingsFrame = new DefaultSpdySettingsFrame();
        this.spdySettingsFrame.setClearPreviouslyPersistedSettings(clearPersisted);
    }

    public void readSetting(int id, int value, boolean persistValue, boolean persisted) {
        this.spdySettingsFrame.setValue(id, value, persistValue, persisted);
    }

    public void readSettingsEnd() {
        SpdySettingsFrame frame = this.spdySettingsFrame;
        this.spdySettingsFrame = null;
        Channels.fireMessageReceived(this.ctx, (Object)frame);
    }

    public void readPingFrame(int id) {
        DefaultSpdyPingFrame spdyPingFrame = new DefaultSpdyPingFrame(id);
        Channels.fireMessageReceived(this.ctx, (Object)spdyPingFrame);
    }

    public void readGoAwayFrame(int lastGoodStreamId, int statusCode) {
        DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(lastGoodStreamId, statusCode);
        Channels.fireMessageReceived(this.ctx, (Object)spdyGoAwayFrame);
    }

    public void readHeadersFrame(int streamId, boolean last) {
        this.spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamId);
        this.spdyHeadersFrame.setLast(last);
    }

    public void readWindowUpdateFrame(int streamId, int deltaWindowSize) {
        DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamId, deltaWindowSize);
        Channels.fireMessageReceived(this.ctx, (Object)spdyWindowUpdateFrame);
    }

    public void readHeaderBlock(ChannelBuffer headerBlock) {
        try {
            this.spdyHeaderBlockDecoder.decode(headerBlock, this.spdyHeadersFrame);
        }
        catch (Exception e) {
            Channels.fireExceptionCaught(this.ctx, (Throwable)e);
        }
    }

    public void readHeaderBlockEnd() {
        SpdyHeadersFrame frame = null;
        try {
            this.spdyHeaderBlockDecoder.endHeaderBlock(this.spdyHeadersFrame);
            frame = this.spdyHeadersFrame;
            this.spdyHeadersFrame = null;
        }
        catch (Exception e) {
            Channels.fireExceptionCaught(this.ctx, (Throwable)e);
        }
        if (frame != null) {
            Channels.fireMessageReceived(this.ctx, (Object)frame);
        }
    }

    public void readFrameError(String message) {
        Channels.fireExceptionCaught(this.ctx, (Throwable)INVALID_FRAME);
    }
}

