/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.string;

import java.nio.charset.Charset;
import shaded.netty.buffer.ChannelBuffers;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (String)msg, this.charset);
        }
        return msg;
    }
}

