/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.controller;

import java.io.Serializable;
import java.util.Set;
import org.resthub.common.exception.NotFoundException;
import org.resthub.web.controller.RestController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class RepositoryBasedRestController<T, ID extends Serializable, R extends PagingAndSortingRepository>
implements RestController<T, ID> {
    protected R repository;
    protected Logger logger = LoggerFactory.getLogger(RepositoryBasedRestController.class);

    public void setRepository(R repository) {
        this.repository = repository;
    }

    @Override
    public T create(@RequestBody T resource) {
        return (T)this.repository.save(resource);
    }

    @Override
    public T update(@PathVariable ID id, @RequestBody T resource) {
        Assert.notNull(id, (String)"id cannot be null");
        T retrievedResource = this.findById(id);
        if (retrievedResource == null) {
            throw new NotFoundException();
        }
        return (T)this.repository.save(resource);
    }

    @Override
    public Iterable<T> findAll() {
        return this.repository.findAll();
    }

    @Override
    public Page<T> findPaginated(@RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="size", required=false, defaultValue="10") Integer size, @RequestParam(value="direction", required=false, defaultValue="") String direction, @RequestParam(value="properties", required=false) String properties) {
        Assert.isTrue((page > 0 ? 1 : 0) != 0, (String)"Page index must be greater than 0");
        Assert.isTrue((direction.isEmpty() || direction.equalsIgnoreCase(Sort.Direction.ASC.toString()) || direction.equalsIgnoreCase(Sort.Direction.DESC.toString()) ? 1 : 0) != 0, (String)"Direction should be ASC or DESC");
        if (direction.isEmpty()) {
            return this.repository.findAll((Pageable)new PageRequest(page - 1, size.intValue()));
        }
        Assert.notNull((Object)properties);
        return this.repository.findAll((Pageable)new PageRequest(page - 1, size.intValue(), new Sort(Sort.Direction.fromString((String)direction.toUpperCase()), properties.split(","))));
    }

    @Override
    public T findById(@PathVariable ID id) {
        Object entity = this.repository.findOne(id);
        if (entity == null) {
            throw new NotFoundException();
        }
        return (T)entity;
    }

    @Override
    public Iterable<T> findByIds(@RequestParam(value="ids[]") Set<ID> ids) {
        Assert.notNull(ids, (String)"ids list cannot be null");
        return this.repository.findAll(ids);
    }

    @Override
    public void delete() {
        Iterable list = this.repository.findAll();
        for (Object entity : list) {
            this.repository.delete(entity);
        }
    }

    @Override
    public void delete(@PathVariable ID id) {
        T resource = this.findById(id);
        this.repository.delete(resource);
    }
}

