/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.controller;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.resthub.common.exception.NotFoundException;
import org.resthub.web.validation.ModelConstraint;
import org.resthub.web.validation.ValidationService;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Profile(value={"resthub-validation"})
@RequestMapping(value={"/api/validation"})
public class ValidationController {
    private ValidationService validationService;

    @Inject
    @Named(value="validationService")
    public void setService(ValidationService validationService) {
        this.validationService = validationService;
    }

    @RequestMapping(value={"{canonicalClassName:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public ModelConstraint getConstraintsForClassName(@PathVariable String canonicalClassName, @RequestParam(required=false) String locale) {
        Locale loc = null;
        try {
            if (locale != null) {
                loc = this.parseLocale(locale);
            }
            return this.validationService.getConstraintsForClassName(canonicalClassName, loc);
        }
        catch (ClassNotFoundException e) {
            throw new NotFoundException("Class " + canonicalClassName + " could not be found", (Throwable)e);
        }
    }

    Locale parseLocale(String locale) {
        String[] locs = locale.split("-");
        Locale loc = locs.length > 2 ? new Locale(locs[0], locs[1], locs[2]) : (locs.length > 1 ? new Locale(locs[0], locs[1]) : new Locale(locs[0]));
        return loc;
    }
}

