/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.view;

import org.resthub.common.view.ResponseView;
import org.resthub.web.view.PojoView;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ViewInjectingReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final HandlerMethodReturnValueHandler delegate;

    public ViewInjectingReturnValueHandler(HandlerMethodReturnValueHandler delegate) {
        this.delegate = delegate;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Class<?> viewClass = this.getDeclaredViewClass(returnType);
        if (viewClass != null) {
            returnValue = this.wrapResult(returnValue, viewClass);
        }
        this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    private Class<?> getDeclaredViewClass(MethodParameter method) {
        ResponseView annotation = (ResponseView)method.getMethodAnnotation(ResponseView.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private Object wrapResult(Object result, Class<?> viewClass) {
        return new PojoView(result, viewClass);
    }
}

