/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractOutputPanel;
import org.richfaces.component.OutputPanelLayout;
import org.richfaces.renderkit.RendererBase;

public class AjaxOutputPanelRenderer
extends RendererBase {
    private static final String[] STYLE_ATTRIBUTES = new String[]{"style", "class"};

    private boolean hasNoneLayout(UIComponent component) {
        return false;
    }

    @Override
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractOutputPanel.class;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractOutputPanel panel = (AbstractOutputPanel)component;
        if (!this.hasNoneLayout(component)) {
            writer.startElement(this.getTag(panel), (UIComponent)panel);
            this.getUtils().encodeId(context, component);
            this.getUtils().encodePassThru(context, component, null);
            this.getUtils().encodeAttributesFromArray(context, component, STYLE_ATTRIBUTES);
        }
    }

    private String getTag(AbstractOutputPanel panel) {
        Object layout = panel.getAttributes().get("layout");
        return OutputPanelLayout.block.equals(layout) ? "div" : "span";
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractOutputPanel panel = (AbstractOutputPanel)component;
        if (!this.hasNoneLayout(component)) {
            writer.endElement(this.getTag(panel));
        }
        if (panel.isKeepTransient()) {
            this.markNoTransient(component);
        }
    }

    private void markNoTransient(UIComponent component) {
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent element = (UIComponent)iter.next();
            this.markNoTransient(element);
            element.setTransient(false);
        }
    }
}

