/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.util.Util;

public abstract class Fs {
    @GuardedBy(value="ZIP_FILESYSTEMS")
    private static final Map<Path, FsWrapper> ZIP_FILESYSTEMS = new HashMap<Path, FsWrapper>();

    @Deprecated
    public static Path newFile(File file) {
        return file.toPath();
    }

    @Deprecated
    public static Path fileFromPath(String path) {
        return Fs.fromUrl(path);
    }

    public static FileSystem forJar(URL url) {
        return Fs.forJar(Paths.get(Fs.toUri(url)));
    }

    public static FileSystem forJar(Path jarFile) {
        try {
            return Fs.getJarFs(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path fromUrl(String urlString) {
        if (urlString.startsWith("file:") || urlString.startsWith("jar:")) {
            URL url;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve path from " + urlString, e);
            }
            return Fs.fromUrl(url);
        }
        return Paths.get(urlString, new String[0]);
    }

    public static Path fromUrl(URL url) {
        try {
            switch (url.getProtocol()) {
                case "file": {
                    return Paths.get(url.toURI());
                }
                case "jar": {
                    String[] parts = url.getPath().split("!", 0);
                    Path jarFile = Paths.get(new URI(parts[0]).toURL().getFile(), new String[0]);
                    FileSystem fs = Fs.getJarFs(jarFile);
                    return fs.getPath(parts[1].substring(1), new String[0]);
                }
            }
            throw new IllegalArgumentException("unsupported fs type for '" + url + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve path from " + url, e);
        }
    }

    public static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid URL: " + url, e);
        }
    }

    static String baseNameFor(Path path) {
        String name = path.getFileName().toString();
        int dotIndex = name.indexOf(".");
        return dotIndex >= 0 ? name.substring(0, dotIndex) : name;
    }

    public static InputStream getInputStream(Path path) throws IOException {
        if (path.toUri().getScheme().equals("file")) {
            return new BufferedInputStream(new FileInputStream(path.toFile()));
        }
        return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
    }

    public static byte[] getBytes(Path path) throws IOException {
        return Util.readBytes((InputStream)Fs.getInputStream(path));
    }

    public static Path[] listFiles(Path path) throws IOException {
        try (Stream<Path> list = Files.list(path);){
            Path[] pathArray = (Path[])list.toArray(Path[]::new);
            return pathArray;
        }
    }

    public static Path[] listFiles(Path path, Predicate<Path> filter) throws IOException {
        try (Stream<Path> list = Files.list(path);){
            Path[] pathArray = (Path[])list.filter(filter).toArray(Path[]::new);
            return pathArray;
        }
    }

    public static String[] listFileNames(Path path) {
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return null;
        }
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
        }
        return strings;
    }

    public static Path join(Path path, String ... pathParts) {
        for (String pathPart : pathParts) {
            path = path.resolve(pathPart);
        }
        return path;
    }

    public static String externalize(Path path) {
        if (path.getFileSystem().provider().getScheme().equals("file")) {
            return path.toString();
        }
        return path.toUri().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getJarFs(Path jarFile) throws IOException {
        Path key = jarFile.toAbsolutePath();
        Map<Path, FsWrapper> map = ZIP_FILESYSTEMS;
        synchronized (map) {
            FsWrapper fs = ZIP_FILESYSTEMS.get(key);
            if (fs == null) {
                fs = new FsWrapper(FileSystems.newFileSystem(key, (ClassLoader)null), key);
                fs.incrRefCount();
                ZIP_FILESYSTEMS.put(key, fs);
            } else {
                fs.incrRefCount();
            }
            return fs;
        }
    }

    private static class FsWrapper
    extends FileSystem {
        private final FileSystem delegate;
        private final Path jarFile;
        @GuardedBy(value="this")
        private int refCount;

        public FsWrapper(FileSystem delegate, Path jarFile) {
            this.delegate = delegate;
            this.jarFile = jarFile;
        }

        synchronized void incrRefCount() {
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void decrRefCount() throws IOException {
            if (--this.refCount == 0) {
                Map map = ZIP_FILESYSTEMS;
                synchronized (map) {
                    ZIP_FILESYSTEMS.remove(this.jarFile);
                }
                this.delegate.close();
            }
        }

        @Override
        public FileSystemProvider provider() {
            return this.delegate.provider();
        }

        @Override
        public void close() throws IOException {
            this.decrRefCount();
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.delegate.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.delegate.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.delegate.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return this.delegate.getPath(first, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.delegate.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.delegate.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.delegate.newWatchService();
        }
    }
}

