/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import org.robolectric.util.Logger;

public class StringResources {
    private static final int CODE_POINT_LENGTH = 4;

    public static String processStringResources(String inputValue) {
        return StringResources.escape(CharMatcher.whitespace().collapseFrom((CharSequence)inputValue.trim(), ' '));
    }

    @VisibleForTesting
    static String escape(String text) {
        if (text.length() > 1 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            text = text.substring(1, text.length() - 1);
        }
        int i = 0;
        int length = text.length();
        StringBuilder result = new StringBuilder(text.length());
        while (true) {
            int j;
            if ((j = text.indexOf(92, i)) == -1) {
                result.append(StringResources.removeUnescapedDoubleQuotes(text.substring(i)));
                break;
            }
            result.append(StringResources.removeUnescapedDoubleQuotes(text.substring(i, j)));
            if (j == length - 1) break;
            boolean isUnicodeEscape = false;
            char escapeCode = text.charAt(j + 1);
            switch (escapeCode) {
                case '\"': 
                case '#': 
                case '\'': 
                case '?': 
                case '@': 
                case '\\': {
                    result.append(escapeCode);
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'u': {
                    isUnicodeEscape = true;
                    break;
                }
                default: {
                    Logger.strict((String)"Unsupported string resource escape code '%s'", (Object[])new Object[]{Character.valueOf(escapeCode)});
                }
            }
            if (!isUnicodeEscape) {
                i = j + 2;
                continue;
            }
            if (length - (j += 2) < 4) {
                throw new IllegalArgumentException("Too short code point: \\u" + text.substring(j));
            }
            String codePoint = text.substring(j, j + 4);
            result.append(StringResources.extractCodePoint(codePoint));
            i = j + 4;
        }
        return result.toString();
    }

    private static char[] extractCodePoint(String codePoint) {
        try {
            return Character.toChars(Integer.valueOf(codePoint, 16));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid code point: \\u" + codePoint, e);
        }
    }

    private static String removeUnescapedDoubleQuotes(String input) {
        return input.replaceAll("\"", "");
    }
}

