/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowActivity;

@Implements(value=Instrumentation.class, looseSignatures=true)
public class ShadowInstrumentation {
    private List<Intent> startedActivities = new ArrayList<Intent>();
    private List<ShadowActivity.IntentForResult> startedActivitiesForResults = new ArrayList<ShadowActivity.IntentForResult>();
    private Map<Intent.FilterComparison, Integer> intentRequestCodeMap = new HashMap<Intent.FilterComparison, Integer>();
    private boolean checkActivities;

    @Implementation
    public Activity startActivitySync(Intent intent, Bundle options) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        return this.logStartedActivity(intent, requestCode, options);
    }

    @Implementation(maxSdk=22)
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        return this.logStartedActivity(intent, requestCode, options);
    }

    private Instrumentation.ActivityResult logStartedActivity(Intent intent, int requestCode, Bundle options) {
        this.startedActivities.add(intent);
        this.intentRequestCodeMap.put(new Intent.FilterComparison(intent), requestCode);
        this.startedActivitiesForResults.add(new ShadowActivity.IntentForResult(intent, requestCode, options));
        return null;
    }

    private void verifyActivityInManifest(Intent intent) {
        if (this.checkActivities && RuntimeEnvironment.application.getPackageManager().resolveActivity(intent, -1) == null) {
            throw new ActivityNotFoundException(intent.getAction());
        }
    }

    @Implementation
    public void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        for (Intent intent : intents) {
            this.execStartActivity(who, contextThread, token, target, intent, -1, options);
        }
    }

    @Implementation(minSdk=21)
    public void execStartActivityFromAppTask(Context who, IBinder contextThread, Object appTask, Intent intent, Bundle options) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation(minSdk=23)
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        this.verifyActivityInManifest(intent);
        return this.logStartedActivity(intent, requestCode, options);
    }

    @Implementation
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String resultWho, Intent intent, int requestCode, Bundle options, UserHandle user) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    @Implementation
    public Instrumentation.ActivityResult execStartActivityAsCaller(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, boolean ignoreTargetSecurity, int userId) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    Intent getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(this.startedActivities.size() - 1);
    }

    Intent peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.get(this.startedActivities.size() - 1);
    }

    ShadowActivity.IntentForResult getNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.remove(this.startedActivitiesForResults.size() - 1);
    }

    ShadowActivity.IntentForResult peekNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.get(this.startedActivitiesForResults.size() - 1);
    }

    void checkActivities(boolean checkActivities) {
        this.checkActivities = checkActivities;
    }

    int getRequestCodeForIntent(Intent requestIntent) {
        Integer requestCode = this.intentRequestCodeMap.get(new Intent.FilterComparison(requestIntent));
        if (requestCode == null) {
            throw new RuntimeException("No intent matches " + requestIntent + " among " + this.intentRequestCodeMap.keySet());
        }
        return requestCode;
    }
}

