/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import org.robolectric.android.Bootstrap;
import org.robolectric.android.ConfigurationV25;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResourceTable;
import org.robolectric.util.Scheduler;
import org.robolectric.util.TempDirectory;

public class RuntimeEnvironment {
    public static Context systemContext;
    @Deprecated
    public static Application application;
    private static volatile Thread mainThread;
    private static Object activityThread;
    private static int apiLevel;
    private static Scheduler masterScheduler;
    private static ResourceTable systemResourceTable;
    private static ResourceTable appResourceTable;
    private static ResourceTable compileTimeResourceTable;
    private static TempDirectory tempDirectory;
    private static String androidFrameworkJar;
    public static FsFile compileTimeSystemResourcesFile;
    private static boolean useLegacyResources;

    public static boolean isMainThread(Thread thread) {
        return thread == mainThread;
    }

    public static boolean isMainThread() {
        return RuntimeEnvironment.isMainThread(Thread.currentThread());
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static void setMainThread(Thread newMainThread) {
        mainThread = newMainThread;
    }

    public static Object getActivityThread() {
        return activityThread;
    }

    public static void setActivityThread(Object newActivityThread) {
        activityThread = newActivityThread;
    }

    public static String getQualifiers() {
        Resources systemResources = Resources.getSystem();
        return RuntimeEnvironment.getQualifiers(systemResources.getConfiguration(), systemResources.getDisplayMetrics());
    }

    public static String getQualifiers(Configuration configuration, DisplayMetrics displayMetrics) {
        return ConfigurationV25.resourceQualifierString(configuration, displayMetrics);
    }

    public static void setQualifiers(String newQualifiers) {
        Configuration configuration;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (newQualifiers.startsWith("+")) {
            configuration = new Configuration(Resources.getSystem().getConfiguration());
            displayMetrics.setTo(Resources.getSystem().getDisplayMetrics());
        } else {
            configuration = new Configuration();
        }
        Bootstrap.applyQualifiers(newQualifiers, RuntimeEnvironment.getApiLevel(), configuration, displayMetrics);
        Resources systemResources = Resources.getSystem();
        systemResources.updateConfiguration(configuration, displayMetrics);
        if (application != null) {
            application.getResources().updateConfiguration(configuration, displayMetrics);
        }
    }

    public static int getApiLevel() {
        return apiLevel;
    }

    public static Number castNativePtr(long ptr) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return ptr;
        }
        return (int)ptr;
    }

    public static Scheduler getMasterScheduler() {
        return masterScheduler;
    }

    public static void setMasterScheduler(Scheduler masterScheduler) {
        RuntimeEnvironment.masterScheduler = masterScheduler;
    }

    public static void setSystemResourceTable(ResourceTable systemResourceTable) {
        RuntimeEnvironment.systemResourceTable = systemResourceTable;
    }

    public static void setAppResourceTable(ResourceTable appResourceTable) {
        RuntimeEnvironment.appResourceTable = appResourceTable;
    }

    public static ResourceTable getSystemResourceTable() {
        return systemResourceTable;
    }

    public static ResourceTable getAppResourceTable() {
        return appResourceTable;
    }

    public static void setCompileTimeResourceTable(ResourceTable compileTimeResourceTable) {
        RuntimeEnvironment.compileTimeResourceTable = compileTimeResourceTable;
    }

    public static ResourceTable getCompileTimeResourceTable() {
        return compileTimeResourceTable;
    }

    public static void setTempDirectory(TempDirectory tempDirectory) {
        RuntimeEnvironment.tempDirectory = tempDirectory;
    }

    public static TempDirectory getTempDirectory() {
        return tempDirectory;
    }

    public static void setAndroidFrameworkJarPath(String localArtifactPath) {
        androidFrameworkJar = localArtifactPath;
    }

    public static String getAndroidFrameworkJarPath() {
        return androidFrameworkJar;
    }

    @Deprecated
    public static boolean useLegacyResources() {
        return useLegacyResources;
    }

    @Deprecated
    public static void setUseLegacyResources(boolean useLegacyResources) {
        RuntimeEnvironment.useLegacyResources = useLegacyResources;
    }

    static {
        mainThread = Thread.currentThread();
        tempDirectory = new TempDirectory("no-test-yet");
    }
}

