/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ActivityThread.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowActivityThread {
    private static ApplicationInfo applicationInfo;

    @Implementation
    public static Object getPackageManager() {
        Class<?> iPackageManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPackageManagerClass = classLoader.loadClass("android.content.pm.IPackageManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPackageManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getApplicationInfo")) {
                    String packageName = (String)args[0];
                    int flags = (Integer)args[1];
                    if (packageName.equals(applicationInfo.packageName)) {
                        return applicationInfo;
                    }
                    try {
                        return RuntimeEnvironment.application.getPackageManager().getApplicationInfo(packageName, flags);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        throw new RemoteException(e.getMessage());
                    }
                }
                if (method.getName().equals("notifyPackageUse")) {
                    return null;
                }
                if (method.getName().equals("getPackageInstaller")) {
                    return null;
                }
                throw new UnsupportedOperationException("sorry, not supporting " + method + " yet!");
            }
        });
    }

    @Implementation
    public static Object currentActivityThread() {
        return RuntimeEnvironment.getActivityThread();
    }

    @Deprecated
    public static void setApplicationInfo(ApplicationInfo applicationInfo) {
        ShadowActivityThread.applicationInfo = applicationInfo;
    }
}

