/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Handler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPendingIntent;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    private final List<ScheduledAlarm> scheduledAlarms = new ArrayList<ScheduledAlarm>();
    @RealObject
    private AlarmManager realObject;

    @Resetter
    public static void reset() {
        TimeZone.setDefault(DEFAULT_TIMEZONE);
    }

    @Implementation
    protected void setTimeZone(String timeZone) {
        ((AlarmManager)Shadow.directlyOn((Object)this.realObject, AlarmManager.class)).setTimeZone(timeZone);
        TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
    }

    @Implementation
    protected void set(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=24)
    protected void set(int type, long triggerAtTime, String tag, AlarmManager.OnAlarmListener listener, Handler targetHandler) {
        this.internalSet(type, triggerAtTime, listener, targetHandler);
    }

    @Implementation(minSdk=19)
    protected void setExact(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=24)
    protected void setExact(int type, long triggerAtTime, String tag, AlarmManager.OnAlarmListener listener, Handler targetHandler) {
        this.internalSet(type, triggerAtTime, listener, targetHandler);
    }

    @Implementation(minSdk=19)
    protected void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.internalSet(type, windowStartMillis, 0L, operation, null);
    }

    @Implementation(minSdk=24)
    protected void setWindow(int type, long windowStartMillis, long windowLengthMillis, String tag, AlarmManager.OnAlarmListener listener, Handler targetHandler) {
        this.internalSet(type, windowStartMillis, listener, targetHandler);
    }

    @Implementation(minSdk=23)
    protected void setAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=23)
    protected void setExactAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation
    protected void setRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, interval, operation, null);
    }

    @Implementation
    protected void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.internalSet(type, triggerAtMillis, intervalMillis, operation, null);
    }

    @Implementation(minSdk=21)
    protected void setAlarmClock(AlarmManager.AlarmClockInfo info, PendingIntent operation) {
        this.internalSet(0, info.getTriggerTime(), 0L, operation, info.getShowIntent());
    }

    @Implementation(minSdk=21)
    protected AlarmManager.AlarmClockInfo getNextAlarmClock() {
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            AlarmManager.AlarmClockInfo alarmClockInfo = scheduledAlarm.getAlarmClockInfo();
            if (alarmClockInfo == null) continue;
            return alarmClockInfo;
        }
        return null;
    }

    private void internalSet(int type, long triggerAtTime, long interval, PendingIntent operation, PendingIntent showIntent) {
        this.cancel(operation);
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, interval, operation, showIntent));
        Collections.sort(this.scheduledAlarms);
    }

    private void internalSet(int type, long triggerAtTime, AlarmManager.OnAlarmListener listener, Handler handler) {
        this.cancel(listener);
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, 0L, listener, handler));
        Collections.sort(this.scheduledAlarms);
    }

    public ScheduledAlarm getNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.remove(0);
    }

    public ScheduledAlarm peekNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.get(0);
    }

    public List<ScheduledAlarm> getScheduledAlarms() {
        return this.scheduledAlarms;
    }

    @Implementation
    protected void cancel(PendingIntent operation) {
        ShadowPendingIntent shadowPendingIntent = (ShadowPendingIntent)Shadow.extract((Object)operation);
        Intent toRemove = shadowPendingIntent.getSavedIntent();
        int requestCode = shadowPendingIntent.getRequestCode();
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            if (scheduledAlarm.operation == null) continue;
            ShadowPendingIntent scheduledShadowPendingIntent = (ShadowPendingIntent)Shadow.extract((Object)scheduledAlarm.operation);
            Intent scheduledIntent = scheduledShadowPendingIntent.getSavedIntent();
            int scheduledRequestCode = scheduledShadowPendingIntent.getRequestCode();
            if (!scheduledIntent.filterEquals(toRemove) || scheduledRequestCode != requestCode) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
    }

    @Implementation(minSdk=24)
    protected void cancel(AlarmManager.OnAlarmListener listener) {
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            if (scheduledAlarm.onAlarmListener == null || !scheduledAlarm.onAlarmListener.equals(listener)) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
    }

    public static class ScheduledAlarm
    implements Comparable<ScheduledAlarm> {
        public final int type;
        public final long triggerAtTime;
        public final long interval;
        public final PendingIntent operation;
        public final PendingIntent showIntent;
        public final AlarmManager.OnAlarmListener onAlarmListener;
        public final Handler handler;

        public ScheduledAlarm(int type, long triggerAtTime, PendingIntent operation, PendingIntent showIntent) {
            this(type, triggerAtTime, 0L, operation, showIntent);
        }

        public ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation, PendingIntent showIntent) {
            this(type, triggerAtTime, interval, operation, showIntent, null, null);
        }

        private ScheduledAlarm(int type, long triggerAtTime, long interval, AlarmManager.OnAlarmListener onAlarmListener, Handler handler) {
            this(type, triggerAtTime, interval, null, null, onAlarmListener, handler);
        }

        private ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation, PendingIntent showIntent, AlarmManager.OnAlarmListener onAlarmListener, Handler handler) {
            this.type = type;
            this.triggerAtTime = triggerAtTime;
            this.operation = operation;
            this.interval = interval;
            this.showIntent = showIntent;
            this.onAlarmListener = onAlarmListener;
            this.handler = handler;
        }

        @TargetApi(value=21)
        public AlarmManager.AlarmClockInfo getAlarmClockInfo() {
            return this.showIntent == null ? null : new AlarmManager.AlarmClockInfo(this.triggerAtTime, this.showIntent);
        }

        @Override
        public int compareTo(ScheduledAlarm scheduledAlarm) {
            return Long.compare(this.triggerAtTime, scheduledAlarm.triggerAtTime);
        }
    }
}

