/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.app.Application;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RoboSettings;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.Provider;
import org.robolectric.shadows.ShadowAlertDialog;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowContextWrapper;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowPopupMenu;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=Application.class)
public class ShadowApplication
extends ShadowContextWrapper {
    @RealObject
    private Application realApplication;
    private Scheduler backgroundScheduler = RoboSettings.isUseGlobalScheduler() ? this.getForegroundThreadScheduler() : new Scheduler();
    private List<Toast> shownToasts = new ArrayList<Toast>();
    private PowerManager.WakeLock latestWakeLock;
    private ShadowAlertDialog latestAlertDialog;
    private ShadowDialog latestDialog;
    private ShadowPopupMenu latestPopupMenu;
    private Object bluetoothAdapter = Shadow.newInstanceOf((String)"android.bluetooth.BluetoothAdapter");
    AppWidgetManager appWidgetManager;
    private PopupWindow latestPopupWindow;
    private ListPopupWindow latestListPopupWindow;
    private final Map<String, Object> singletons = new HashMap<String, Object>();

    @Deprecated
    public static ShadowApplication getInstance() {
        return RuntimeEnvironment.application == null ? null : (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
    }

    public static void runBackgroundTasks() {
        ShadowApplication.getInstance().getBackgroundThreadScheduler().advanceBy(0L);
    }

    public void callAttach(Context context) {
        ReflectionHelpers.callInstanceMethod(Application.class, (Object)this.realApplication, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    public List<Toast> getShownToasts() {
        return this.shownToasts;
    }

    public Scheduler getForegroundThreadScheduler() {
        return RuntimeEnvironment.getMasterScheduler();
    }

    public Scheduler getBackgroundThreadScheduler() {
        return this.backgroundScheduler;
    }

    public void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        this.getShadowInstrumentation().setComponentNameAndServiceForBindService(name, service);
    }

    public void setComponentNameAndServiceForBindServiceForIntent(Intent intent, ComponentName name, IBinder service) {
        this.getShadowInstrumentation().setComponentNameAndServiceForBindServiceForIntent(intent, name, service);
    }

    public void assertNoBroadcastListenersOfActionRegistered(ContextWrapper context, String action) {
        this.getShadowInstrumentation().assertNoBroadcastListenersOfActionRegistered(context, action);
    }

    public List<ServiceConnection> getBoundServiceConnections() {
        return this.getShadowInstrumentation().getBoundServiceConnections();
    }

    public void setUnbindServiceShouldThrowIllegalArgument(boolean flag) {
        this.getShadowInstrumentation().setUnbindServiceShouldThrowIllegalArgument(flag);
    }

    public List<ServiceConnection> getUnboundServiceConnections() {
        return this.getShadowInstrumentation().getUnboundServiceConnections();
    }

    @Deprecated
    public boolean hasReceiverForIntent(Intent intent) {
        return this.getShadowInstrumentation().hasReceiverForIntent(intent);
    }

    @Deprecated
    public List<BroadcastReceiver> getReceiversForIntent(Intent intent) {
        return this.getShadowInstrumentation().getReceiversForIntent(intent);
    }

    public List<Wrapper> getRegisteredReceivers() {
        return this.getShadowInstrumentation().getRegisteredReceivers();
    }

    public AppWidgetManager getAppWidgetManager() {
        return this.appWidgetManager;
    }

    @Deprecated
    public ShadowAlertDialog getLatestAlertDialog() {
        return this.latestAlertDialog;
    }

    protected void setLatestAlertDialog(ShadowAlertDialog latestAlertDialog) {
        this.latestAlertDialog = latestAlertDialog;
    }

    @Deprecated
    public ShadowDialog getLatestDialog() {
        return this.latestDialog;
    }

    protected void setLatestDialog(ShadowDialog latestDialog) {
        this.latestDialog = latestDialog;
    }

    public Object getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public void declareActionUnbindable(String action) {
        this.getShadowInstrumentation().declareActionUnbindable(action);
    }

    public PowerManager.WakeLock getLatestWakeLock() {
        return this.latestWakeLock;
    }

    public void addWakeLock(PowerManager.WakeLock wl) {
        this.latestWakeLock = wl;
    }

    public void clearWakeLocks() {
        this.latestWakeLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleton(Class<T> clazz, Provider<T> provider) {
        Map<String, Object> map = this.singletons;
        synchronized (map) {
            Object item = this.singletons.get(clazz.getName());
            if (item == null) {
                item = provider.get();
                this.singletons.put(clazz.getName(), item);
            }
            return (T)item;
        }
    }

    public void checkActivities(boolean checkActivities) {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        shadowInstrumentation.checkActivities(checkActivities);
    }

    @Deprecated
    public ShadowPopupMenu getLatestPopupMenu() {
        return this.latestPopupMenu;
    }

    protected void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        this.latestPopupMenu = latestPopupMenu;
    }

    public PopupWindow getLatestPopupWindow() {
        return this.latestPopupWindow;
    }

    protected void setLatestPopupWindow(PopupWindow latestPopupWindow) {
        this.latestPopupWindow = latestPopupWindow;
    }

    public ListPopupWindow getLatestListPopupWindow() {
        return this.latestListPopupWindow;
    }

    protected void setLatestListPopupWindow(ListPopupWindow latestListPopupWindow) {
        this.latestListPopupWindow = latestListPopupWindow;
    }

    @Deprecated
    public void setSystemService(String key, Object service) {
        ShadowContextImpl shadowContext = (ShadowContextImpl)Shadow.extract((Object)this.realApplication.getBaseContext());
        shadowContext.setSystemService(key, service);
    }

    public static class Wrapper {
        public BroadcastReceiver broadcastReceiver;
        public IntentFilter intentFilter;
        public Context context;
        public Throwable exception;
        public String broadcastPermission;
        public Handler scheduler;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, Context context, String broadcastPermission, Handler scheduler) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
            this.context = context;
            this.broadcastPermission = broadcastPermission;
            this.scheduler = scheduler;
            this.exception = new Throwable();
        }

        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }

        public IntentFilter getIntentFilter() {
            return this.intentFilter;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

