/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AudioManager.class)
public class ShadowAudioManager {
    public static final int MAX_VOLUME_MUSIC_DTMF = 15;
    public static final int DEFAULT_MAX_VOLUME = 7;
    public static final int DEFAULT_VOLUME = 7;
    public static final int INVALID_VOLUME = 0;
    public static final int FLAG_NO_ACTION = 0;
    public static final int[] ALL_STREAMS = new int[]{3, 4, 5, 2, 1, 0, 8};
    private AudioFocusRequest lastAudioFocusRequest;
    private int nextResponseValue = 1;
    private AudioManager.OnAudioFocusChangeListener lastAbandonedAudioFocusListener;
    private android.media.AudioFocusRequest lastAbandonedAudioFocusRequest;
    private HashMap<Integer, AudioStream> streamStatus = new HashMap();
    private List<AudioPlaybackConfiguration> activePlaybackConfigurations = Collections.emptyList();
    private int ringerMode = 2;
    private int mode = 0;
    private boolean bluetoothA2dpOn;
    private boolean isBluetoothScoOn;
    private boolean isSpeakerphoneOn;
    private boolean isMicrophoneMuted = false;
    private boolean isMusicActive;
    private boolean wiredHeadsetOn;

    public ShadowAudioManager() {
        for (int stream : ALL_STREAMS) {
            this.streamStatus.put(stream, new AudioStream(7, 7, 0));
        }
        this.streamStatus.get(3).setMaxVolume(15);
        this.streamStatus.get(8).setMaxVolume(15);
    }

    @Implementation
    protected int getStreamMaxVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getMaxVolume() : 0;
    }

    @Implementation
    protected int getStreamVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getCurrentVolume() : 0;
    }

    @Implementation
    protected void setStreamVolume(int streamType, int index, int flags) {
        AudioStream stream = this.streamStatus.get(streamType);
        if (stream != null) {
            stream.setCurrentVolume(index);
            stream.setFlag(flags);
        }
    }

    @Implementation
    protected int requestAudioFocus(AudioManager.OnAudioFocusChangeListener l, int streamType, int durationHint) {
        this.lastAudioFocusRequest = new AudioFocusRequest(l, streamType, durationHint);
        return this.nextResponseValue;
    }

    @Implementation(minSdk=26)
    protected int requestAudioFocus(android.media.AudioFocusRequest audioFocusRequest) {
        this.lastAudioFocusRequest = new AudioFocusRequest(audioFocusRequest);
        return this.nextResponseValue;
    }

    @Implementation
    protected int abandonAudioFocus(AudioManager.OnAudioFocusChangeListener l) {
        this.lastAbandonedAudioFocusListener = l;
        return this.nextResponseValue;
    }

    @Implementation(minSdk=26)
    protected int abandonAudioFocusRequest(android.media.AudioFocusRequest audioFocusRequest) {
        this.lastAbandonedAudioFocusRequest = audioFocusRequest;
        return this.nextResponseValue;
    }

    @Implementation
    protected int getRingerMode() {
        return this.ringerMode;
    }

    @Implementation
    protected void setRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode((int)ringerMode)) {
            return;
        }
        this.ringerMode = ringerMode;
    }

    public static boolean isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= (Integer)ReflectionHelpers.getStaticField(AudioManager.class, (String)"RINGER_MODE_MAX");
    }

    @Implementation
    protected void setMode(int mode) {
        this.mode = mode;
    }

    @Implementation
    protected int getMode() {
        return this.mode;
    }

    public void setStreamMaxVolume(int streamMaxVolume) {
        for (Map.Entry<Integer, AudioStream> entry : this.streamStatus.entrySet()) {
            entry.getValue().setMaxVolume(streamMaxVolume);
        }
    }

    public void setStreamVolume(int streamVolume) {
        for (Map.Entry<Integer, AudioStream> entry : this.streamStatus.entrySet()) {
            entry.getValue().setCurrentVolume(streamVolume);
        }
    }

    @Implementation
    protected void setWiredHeadsetOn(boolean on) {
        this.wiredHeadsetOn = on;
    }

    @Implementation
    protected boolean isWiredHeadsetOn() {
        return this.wiredHeadsetOn;
    }

    @Implementation
    protected void setBluetoothA2dpOn(boolean on) {
        this.bluetoothA2dpOn = on;
    }

    @Implementation
    protected boolean isBluetoothA2dpOn() {
        return this.bluetoothA2dpOn;
    }

    @Implementation
    protected void setSpeakerphoneOn(boolean on) {
        this.isSpeakerphoneOn = on;
    }

    @Implementation
    protected boolean isSpeakerphoneOn() {
        return this.isSpeakerphoneOn;
    }

    @Implementation
    protected void setMicrophoneMute(boolean on) {
        this.isMicrophoneMuted = on;
    }

    @Implementation
    protected boolean isMicrophoneMute() {
        return this.isMicrophoneMuted;
    }

    @Implementation
    protected boolean isBluetoothScoOn() {
        return this.isBluetoothScoOn;
    }

    @Implementation
    protected void setBluetoothScoOn(boolean isBluetoothScoOn) {
        this.isBluetoothScoOn = isBluetoothScoOn;
    }

    @Implementation
    protected boolean isMusicActive() {
        return this.isMusicActive;
    }

    @Implementation(minSdk=26)
    protected List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() {
        return new ArrayList<AudioPlaybackConfiguration>(this.activePlaybackConfigurations);
    }

    @TargetApi(value=26)
    public void setActivePlaybackConfigurationsFor(List<AudioAttributes> audioAttributes) {
        this.activePlaybackConfigurations = new ArrayList<AudioPlaybackConfiguration>(audioAttributes.size());
        for (AudioAttributes audioAttribute : audioAttributes) {
            Parcel p = Parcel.obtain();
            p.writeInt(0);
            p.writeInt(0);
            p.writeInt(0);
            p.writeInt(0);
            p.writeInt(2);
            audioAttribute.writeToParcel(p, 0);
            p.writeStrongInterface(null);
            byte[] bytes = p.marshall();
            p.recycle();
            p = Parcel.obtain();
            p.unmarshall(bytes, 0, bytes.length);
            AudioPlaybackConfiguration configuration = (AudioPlaybackConfiguration)AudioPlaybackConfiguration.CREATOR.createFromParcel(p);
            p.recycle();
            this.activePlaybackConfigurations.add(configuration);
        }
    }

    public void setIsMusicActive(boolean isMusicActive) {
        this.isMusicActive = isMusicActive;
    }

    public AudioFocusRequest getLastAudioFocusRequest() {
        return this.lastAudioFocusRequest;
    }

    public void setNextFocusRequestResponse(int nextResponseValue) {
        this.nextResponseValue = nextResponseValue;
    }

    public AudioManager.OnAudioFocusChangeListener getLastAbandonedAudioFocusListener() {
        return this.lastAbandonedAudioFocusListener;
    }

    public android.media.AudioFocusRequest getLastAbandonedAudioFocusRequest() {
        return this.lastAbandonedAudioFocusRequest;
    }

    private static class AudioStream {
        private int currentVolume;
        private int maxVolume;
        private int flag;

        public AudioStream(int currVol, int maxVol, int flag) {
            this.setCurrentVolume(currVol);
            this.setMaxVolume(maxVol);
            this.setFlag(flag);
        }

        public int getCurrentVolume() {
            return this.currentVolume;
        }

        public int getMaxVolume() {
            return this.maxVolume;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setCurrentVolume(int vol) {
            if (vol > this.maxVolume) {
                vol = this.maxVolume;
            } else if (vol < 0) {
                vol = 0;
            }
            this.currentVolume = vol;
        }

        public void setMaxVolume(int vol) {
            this.maxVolume = vol;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }
    }

    public static class AudioFocusRequest {
        public final AudioManager.OnAudioFocusChangeListener listener;
        public final int streamType;
        public final int durationHint;
        public final android.media.AudioFocusRequest audioFocusRequest;

        private AudioFocusRequest(AudioManager.OnAudioFocusChangeListener listener, int streamType, int durationHint) {
            this.listener = listener;
            this.streamType = streamType;
            this.durationHint = durationHint;
            this.audioFocusRequest = null;
        }

        private AudioFocusRequest(android.media.AudioFocusRequest audioFocusRequest) {
            this.listener = null;
            this.durationHint = -1;
            this.streamType = -1;
            this.audioFocusRequest = audioFocusRequest;
        }
    }
}

