/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BatteryManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BatteryManager.class)
public class ShadowBatteryManager {
    private boolean isCharging = false;
    private final Map<Integer, Long> longProperties = new HashMap<Integer, Long>();
    private final Map<Integer, Integer> intProperties = new HashMap<Integer, Integer>();

    @Implementation(minSdk=23)
    protected boolean isCharging() {
        return this.isCharging;
    }

    public void setIsCharging(boolean charging) {
        this.isCharging = charging;
    }

    @Implementation(minSdk=21)
    protected int getIntProperty(int id2) {
        return this.intProperties.containsKey(id2) ? this.intProperties.get(id2) : Integer.MIN_VALUE;
    }

    public void setIntProperty(int id2, int value) {
        this.intProperties.put(id2, value);
    }

    @Implementation(minSdk=21)
    protected long getLongProperty(int id2) {
        return this.longProperties.containsKey(id2) ? this.longProperties.get(id2) : Long.MIN_VALUE;
    }

    public void setLongProperty(int id2, long value) {
        this.longProperties.put(id2, value);
    }
}

