/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.ArraySet;
import android.view.accessibility.CaptioningManager;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CaptioningManager.class)
public class ShadowCaptioningManager {
    private float fontScale = 1.0f;
    private boolean isEnabled = false;
    private final ArraySet<CaptioningManager.CaptioningChangeListener> listeners = new ArraySet();

    @Implementation(minSdk=19)
    protected float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
        for (CaptioningManager.CaptioningChangeListener captioningChangeListener : this.listeners) {
            captioningChangeListener.onFontScaleChanged(fontScale);
        }
    }

    @Implementation(minSdk=19)
    protected boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Implementation(minSdk=19)
    protected void addCaptioningChangeListener(CaptioningManager.CaptioningChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Implementation(minSdk=19)
    protected void removeCaptioningChangeListener(CaptioningManager.CaptioningChangeListener listener) {
        this.listeners.remove((Object)listener);
    }
}

