/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.ibm.icu.text.DateIntervalFormat;
import com.ibm.icu.util.DateInterval;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=libcore.icu.DateIntervalFormat.class, isInAndroidSdk=false, minSdk=19)
public class ShadowDateIntervalFormat {
    private static long address;
    private static Map<Long, DateIntervalFormat> INTERVAL_CACHE;

    @Implementation(maxSdk=22)
    public static long createDateIntervalFormat(String skeleton, String localeName, String tzName) {
        INTERVAL_CACHE.put(++address, DateIntervalFormat.getInstance((String)skeleton, (Locale)new Locale(localeName)));
        return address;
    }

    @Implementation(maxSdk=22)
    public static void destroyDateIntervalFormat(long address) {
        INTERVAL_CACHE.remove(address);
    }

    @Implementation(maxSdk=22)
    public static String formatDateInterval(long address, long fromDate, long toDate) {
        StringBuffer buffer = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        INTERVAL_CACHE.get(address).format(new DateInterval(fromDate, toDate), buffer, pos);
        return buffer.toString();
    }

    static {
        INTERVAL_CACHE = new HashMap<Long, DateIntervalFormat>();
    }
}

