/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Looper;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=LocationManager.class)
public class ShadowLocationManager {
    @RealObject
    private LocationManager realLocationManager;
    private final Map<UserHandle, Boolean> locationEnabledForUser = new HashMap<UserHandle, Boolean>();
    private final Map<String, LocationProviderEntry> providersEnabled = new LinkedHashMap<String, LocationProviderEntry>();
    private final Map<String, Location> lastKnownLocations = new HashMap<String, Location>();
    private final Map<PendingIntent, Criteria> requestLocationUdpateCriteriaPendingIntents = new HashMap<PendingIntent, Criteria>();
    private final Map<PendingIntent, String> requestLocationUdpateProviderPendingIntents = new HashMap<PendingIntent, String>();
    private final ArrayList<LocationListener> removedLocationListeners = new ArrayList();
    private final ArrayList<GpsStatus.Listener> gpsStatusListeners = new ArrayList();
    private Criteria lastBestProviderCriteria;
    private boolean lastBestProviderEnabled;
    private String bestEnabledProvider;
    private String bestDisabledProvider;
    private final Map<String, List<ListenerRegistration>> locationListeners = new HashMap<String, List<ListenerRegistration>>();

    @Implementation
    protected boolean isProviderEnabled(String provider) {
        LocationProviderEntry map = this.providersEnabled.get(provider);
        if (map != null) {
            Boolean isEnabled = map.getKey();
            return isEnabled == null ? true : isEnabled;
        }
        return false;
    }

    @Implementation
    protected List<String> getAllProviders() {
        LinkedHashSet<String> allKnownProviders = new LinkedHashSet<String>(this.providersEnabled.keySet());
        allKnownProviders.add("gps");
        allKnownProviders.add("network");
        allKnownProviders.add("passive");
        return new ArrayList<String>(allKnownProviders);
    }

    public void setProviderEnabled(String provider, boolean isEnabled) {
        this.setProviderEnabled(provider, isEnabled, null);
    }

    public void setProviderEnabled(String provider, boolean isEnabled, List<Criteria> criteria) {
        LocationProviderEntry providerEntry = this.providersEnabled.get(provider);
        if (providerEntry == null) {
            providerEntry = new LocationProviderEntry();
        }
        providerEntry.enabled = isEnabled;
        providerEntry.criteria = criteria;
        this.providersEnabled.put(provider, providerEntry);
        ArrayList<LocationListener> locationUpdateListeners = new ArrayList<LocationListener>(this.getRequestLocationUpdateListeners());
        for (LocationListener locationUpdateListener : locationUpdateListeners) {
            if (isEnabled) {
                locationUpdateListener.onProviderEnabled(provider);
                continue;
            }
            locationUpdateListener.onProviderDisabled(provider);
        }
        Intent intent = new Intent();
        intent.putExtra("providerEnabled", isEnabled);
        this.getContext().sendBroadcast(intent);
        Set<PendingIntent> requestLocationUdpatePendingIntentSet = this.requestLocationUdpateCriteriaPendingIntents.keySet();
        for (PendingIntent requestLocationUdpatePendingIntent : requestLocationUdpatePendingIntentSet) {
            try {
                requestLocationUdpatePendingIntent.send();
            }
            catch (PendingIntent.CanceledException e) {
                this.requestLocationUdpateCriteriaPendingIntents.remove(requestLocationUdpatePendingIntent);
            }
        }
        if (provider.equals(this.bestEnabledProvider) && !isEnabled) {
            this.bestEnabledProvider = null;
        }
    }

    @Implementation
    protected List<String> getProviders(boolean enabledOnly) {
        ArrayList<String> enabledProviders = new ArrayList<String>();
        for (String provider : this.getAllProviders()) {
            if (enabledOnly && this.providersEnabled.get(provider) == null) continue;
            enabledProviders.add(provider);
        }
        return enabledProviders;
    }

    @Implementation
    protected Location getLastKnownLocation(String provider) {
        return this.lastKnownLocations.get(provider);
    }

    @Implementation
    protected boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (!this.gpsStatusListeners.contains(listener)) {
            this.gpsStatusListeners.add(listener);
        }
        return true;
    }

    @Implementation
    protected void removeGpsStatusListener(GpsStatus.Listener listener) {
        this.gpsStatusListeners.remove(listener);
    }

    @Implementation
    protected String getBestProvider(Criteria criteria, boolean enabled) {
        this.lastBestProviderCriteria = criteria;
        this.lastBestProviderEnabled = enabled;
        if (criteria == null) {
            return this.getBestProviderWithNoCriteria(enabled);
        }
        return this.getBestProviderWithCriteria(criteria, enabled);
    }

    private String getBestProviderWithCriteria(Criteria criteria, boolean enabled) {
        List<String> providers = this.getProviders(enabled);
        int powerRequirement = criteria.getPowerRequirement();
        int accuracy = criteria.getAccuracy();
        for (String provider : providers) {
            Object criteriaList;
            LocationProviderEntry locationProviderEntry = this.providersEnabled.get(provider);
            if (locationProviderEntry == null || (criteriaList = locationProviderEntry.getValue()) == null) continue;
            Iterator iterator = criteriaList.iterator();
            while (iterator.hasNext()) {
                Criteria criteriaListItem = (Criteria)iterator.next();
                if (criteria.equals(criteriaListItem)) {
                    return provider;
                }
                if (criteriaListItem.getAccuracy() == accuracy) {
                    return provider;
                }
                if (criteriaListItem.getPowerRequirement() != powerRequirement) continue;
                return provider;
            }
        }
        for (String provider : providers) {
            if (provider.equals("network") && (accuracy == 2 || powerRequirement == 1)) {
                return provider;
            }
            if (!provider.equals("gps") || accuracy != 1 || powerRequirement == 1) continue;
            return provider;
        }
        return providers.isEmpty() ? null : providers.get(0);
    }

    private String getBestProviderWithNoCriteria(boolean enabled) {
        List<String> providers = this.getProviders(enabled);
        if (enabled && this.bestEnabledProvider != null) {
            return this.bestEnabledProvider;
        }
        if (this.bestDisabledProvider != null) {
            return this.bestDisabledProvider;
        }
        if (providers.contains("gps")) {
            return "gps";
        }
        if (providers.contains("network")) {
            return "network";
        }
        return null;
    }

    @Implementation(minSdk=28)
    protected void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        this.getContext().checkCallingPermission("android.permission.WRITE_SECURE_SETTINGS");
        this.locationEnabledForUser.put(userHandle, enabled);
    }

    @Implementation(minSdk=28)
    protected boolean isLocationEnabledForUser(UserHandle userHandle) {
        Boolean result = this.locationEnabledForUser.get(userHandle);
        return result == null ? false : result;
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        this.addLocationListener(provider, listener, minTime, minDistance);
    }

    private void addLocationListener(String provider, LocationListener listener, long minTime, float minDistance) {
        List<ListenerRegistration> providerListeners = this.locationListeners.get(provider);
        if (providerListeners == null) {
            providerListeners = new ArrayList<ListenerRegistration>();
            this.locationListeners.put(provider, providerListeners);
        }
        this.removeDuplicates(listener, providerListeners);
        providerListeners.add(new ListenerRegistration(provider, minTime, minDistance, this.copyOf(this.getLastKnownLocation(provider)), listener));
    }

    private void removeDuplicates(LocationListener listener, List<ListenerRegistration> providerListeners) {
        Iterator<ListenerRegistration> iterator = providerListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().listener.equals(listener)) continue;
            iterator.remove();
        }
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        this.addLocationListener(provider, listener, minTime, minDistance);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalStateException("Intent must not be null");
        }
        if (this.getBestProvider(criteria, true) == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUdpateCriteriaPendingIntents.put(pendingIntent, criteria);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalStateException("Intent must not be null");
        }
        if (!this.providersEnabled.containsKey(provider)) {
            throw new IllegalArgumentException("no providers found");
        }
        this.requestLocationUdpateProviderPendingIntents.put(pendingIntent, provider);
    }

    @Implementation
    protected void removeUpdates(LocationListener listener) {
        this.removedLocationListeners.add(listener);
    }

    private void cleanupRemovedLocationListeners() {
        for (Map.Entry<String, List<ListenerRegistration>> entry : this.locationListeners.entrySet()) {
            List<ListenerRegistration> listenerRegistrations = entry.getValue();
            for (int i = listenerRegistrations.size() - 1; i >= 0; --i) {
                LocationListener listener = listenerRegistrations.get((int)i).listener;
                if (!this.removedLocationListeners.contains(listener)) continue;
                listenerRegistrations.remove(i);
            }
        }
    }

    @Implementation
    protected void removeUpdates(PendingIntent pendingIntent) {
        while (this.requestLocationUdpateCriteriaPendingIntents.remove(pendingIntent) != null) {
        }
        while (this.requestLocationUdpateProviderPendingIntents.remove(pendingIntent) != null) {
        }
    }

    public boolean hasGpsStatusListener(GpsStatus.Listener listener) {
        return this.gpsStatusListeners.contains(listener);
    }

    public Criteria getLastBestProviderCriteria() {
        return this.lastBestProviderCriteria;
    }

    public boolean getLastBestProviderEnabledOnly() {
        return this.lastBestProviderEnabled;
    }

    public boolean setBestProvider(String provider, boolean enabled, List<Criteria> criteria) throws Exception {
        LocationProviderEntry entry;
        if (!this.getAllProviders().contains(provider)) {
            throw new IllegalStateException("Best provider is not a known provider");
        }
        for (String prvdr : this.providersEnabled.keySet()) {
            if (!provider.equals(prvdr) || this.providersEnabled.get(prvdr).enabled == enabled) continue;
            return false;
        }
        if (enabled) {
            this.bestEnabledProvider = provider;
            if (provider.equals(this.bestDisabledProvider)) {
                this.bestDisabledProvider = null;
            }
        } else {
            this.bestDisabledProvider = provider;
            if (provider.equals(this.bestEnabledProvider)) {
                this.bestEnabledProvider = null;
            }
        }
        if (criteria == null) {
            return true;
        }
        if (!this.providersEnabled.containsKey(provider)) {
            entry = new LocationProviderEntry();
            entry.enabled = enabled;
            entry.criteria = criteria;
        } else {
            entry = this.providersEnabled.get(provider);
        }
        this.providersEnabled.put(provider, entry);
        return true;
    }

    public boolean setBestProvider(String provider, boolean enabled) throws Exception {
        return this.setBestProvider(provider, enabled, null);
    }

    public void setLastKnownLocation(String provider, Location location) {
        this.lastKnownLocations.put(provider, location);
    }

    public List<LocationListener> getRequestLocationUpdateListeners() {
        this.cleanupRemovedLocationListeners();
        ArrayList<LocationListener> all = new ArrayList<LocationListener>();
        for (Map.Entry<String, List<ListenerRegistration>> entry : this.locationListeners.entrySet()) {
            for (ListenerRegistration reg : entry.getValue()) {
                all.add(reg.listener);
            }
        }
        return all;
    }

    public void simulateLocation(Location location) {
        this.cleanupRemovedLocationListeners();
        this.setLastKnownLocation(location.getProvider(), location);
        List<ListenerRegistration> providerListeners = this.locationListeners.get(location.getProvider());
        if (providerListeners == null) {
            return;
        }
        for (ListenerRegistration listenerReg : providerListeners) {
            if (listenerReg.lastSeenLocation != null && location != null) {
                boolean exceededMinTime;
                float distanceChange = ShadowLocationManager.distanceBetween(location, listenerReg.lastSeenLocation);
                boolean withinMinDistance = distanceChange < listenerReg.minDistance;
                boolean bl = exceededMinTime = location.getTime() - listenerReg.lastSeenTime > listenerReg.minTime;
                if (withinMinDistance || !exceededMinTime) continue;
            }
            listenerReg.lastSeenLocation = this.copyOf(location);
            listenerReg.lastSeenTime = location == null ? 0L : location.getTime();
            listenerReg.listener.onLocationChanged(this.copyOf(location));
        }
        this.cleanupRemovedLocationListeners();
    }

    private Location copyOf(Location location) {
        if (location == null) {
            return null;
        }
        Location copy = new Location(location);
        copy.setAccuracy(location.getAccuracy());
        copy.setAltitude(location.getAltitude());
        copy.setBearing(location.getBearing());
        copy.setExtras(location.getExtras());
        copy.setLatitude(location.getLatitude());
        copy.setLongitude(location.getLongitude());
        copy.setProvider(location.getProvider());
        copy.setSpeed(location.getSpeed());
        copy.setTime(location.getTime());
        return copy;
    }

    private static float distanceBetween(Location location1, Location location2) {
        double earthRadius = 3958.75;
        double latDifference = Math.toRadians(location2.getLatitude() - location1.getLatitude());
        double lonDifference = Math.toRadians(location2.getLongitude() - location1.getLongitude());
        double a = Math.sin(latDifference / 2.0) * Math.sin(latDifference / 2.0) + Math.cos(Math.toRadians(location1.getLatitude())) * Math.cos(Math.toRadians(location2.getLatitude())) * Math.sin(lonDifference / 2.0) * Math.sin(lonDifference / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = Math.abs(earthRadius * c);
        int meterConversion = 1609;
        return (float)(dist * (double)meterConversion);
    }

    public Map<PendingIntent, Criteria> getRequestLocationUdpateCriteriaPendingIntents() {
        return this.requestLocationUdpateCriteriaPendingIntents;
    }

    public Map<PendingIntent, String> getRequestLocationUdpateProviderPendingIntents() {
        return this.requestLocationUdpateProviderPendingIntents;
    }

    public Collection<String> getProvidersForListener(LocationListener listener) {
        this.cleanupRemovedLocationListeners();
        HashSet<String> providers = new HashSet<String>();
        for (List<ListenerRegistration> listenerRegistrations : this.locationListeners.values()) {
            for (ListenerRegistration listenerRegistration : listenerRegistrations) {
                if (listenerRegistration.listener != listener) continue;
                providers.add(listenerRegistration.provider);
            }
        }
        return providers;
    }

    private Context getContext() {
        return (Context)ReflectionHelpers.getField((Object)this.realLocationManager, (String)"mContext");
    }

    private static final class LocationProviderEntry
    implements Map.Entry<Boolean, List<Criteria>> {
        private Boolean enabled;
        private List<Criteria> criteria;

        private LocationProviderEntry() {
        }

        @Override
        public Boolean getKey() {
            return this.enabled;
        }

        @Override
        public List<Criteria> getValue() {
            return this.criteria;
        }

        @Override
        public List<Criteria> setValue(List<Criteria> criteria) {
            List<Criteria> oldCriteria = this.criteria;
            this.criteria = criteria;
            return oldCriteria;
        }
    }

    private static final class ListenerRegistration {
        final long minTime;
        final float minDistance;
        final LocationListener listener;
        final String provider;
        Location lastSeenLocation;
        long lastSeenTime;

        ListenerRegistration(String provider, long minTime, float minDistance, Location locationAtCreation, LocationListener listener) {
            this.provider = provider;
            this.minTime = minTime;
            this.minDistance = minDistance;
            this.lastSeenTime = locationAtCreation == null ? 0L : locationAtCreation.getTime();
            this.lastSeenLocation = locationAtCreation;
            this.listener = listener;
        }
    }
}

