/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.os.MessageQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.robolectric.RoboSettings;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMessageQueue;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=Looper.class)
public class ShadowLooper {
    private static Map<Thread, Looper> loopingLoopers = Collections.synchronizedMap(new WeakHashMap());
    private static Looper mainLooper;
    @RealObject
    private Looper realObject;
    boolean quit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static synchronized void resetThreadLoopers() {
        if (!RuntimeEnvironment.isMainThread()) {
            throw new IllegalStateException("you should only be calling this from the main thread!");
        }
        Map<Thread, Looper> map = loopingLoopers;
        synchronized (map) {
            Iterator<Looper> iterator = loopingLoopers.values().iterator();
            while (iterator.hasNext()) {
                Looper looper;
                Looper looper2 = looper = iterator.next();
                synchronized (looper2) {
                    if (!ShadowLooper.shadowOf((Looper)looper).quit) {
                        looper.quit();
                    } else {
                        ShadowLooper.shadowOf(looper).getScheduler().reset();
                        ShadowLooper.shadowOf(looper.getQueue()).reset();
                    }
                }
            }
        }
        if (mainLooper != null) {
            ShadowLooper.shadowOf(mainLooper).reset();
        }
    }

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        Shadow.invokeConstructor(Looper.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)quitAllowed)});
        if (RuntimeEnvironment.isMainThread()) {
            mainLooper = this.realObject;
        } else {
            loopingLoopers.put(Thread.currentThread(), this.realObject);
        }
        this.resetScheduler();
    }

    @Implementation
    protected static Looper getMainLooper() {
        return mainLooper;
    }

    @Implementation
    protected static Looper myLooper() {
        return ShadowLooper.getLooperForThread(Thread.currentThread());
    }

    @Implementation
    protected static void loop() {
        ShadowLooper.shadowOf(Looper.myLooper()).doLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoop() {
        if (this.realObject != Looper.getMainLooper()) {
            Looper looper = this.realObject;
            synchronized (looper) {
                while (!this.quit) {
                    try {
                        this.realObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Implementation
    protected void quit() {
        if (this.realObject == Looper.getMainLooper()) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        this.quitUnchecked();
    }

    @Implementation(minSdk=18)
    protected void quitSafely() {
        this.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quitUnchecked() {
        Looper looper = this.realObject;
        synchronized (looper) {
            this.quit = true;
            this.realObject.notifyAll();
            this.getScheduler().reset();
            ShadowLooper.shadowOf(this.realObject.getQueue()).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQuit() {
        Looper looper = this.realObject;
        synchronized (looper) {
            return this.quit;
        }
    }

    @Deprecated
    public static ShadowLooper getShadowMainLooper() {
        return ShadowLooper.shadowOf(Looper.getMainLooper());
    }

    public static Looper getLooperForThread(Thread thread) {
        return RuntimeEnvironment.isMainThread(thread) ? mainLooper : loopingLoopers.get(thread);
    }

    public static void pauseLooper(Looper looper) {
        ShadowLooper.shadowOf(looper).pause();
    }

    public static void unPauseLooper(Looper looper) {
        ShadowLooper.shadowOf(looper).unPause();
    }

    public static void pauseMainLooper() {
        ShadowLooper.getShadowMainLooper().pause();
    }

    public static void unPauseMainLooper() {
        ShadowLooper.getShadowMainLooper().unPause();
    }

    public static void idleMainLooper() {
        ShadowLooper.getShadowMainLooper().idle();
    }

    @Deprecated
    public static void idleMainLooper(long interval) {
        ShadowLooper.idleMainLooper(interval, TimeUnit.MILLISECONDS);
    }

    public static void idleMainLooper(long amount, TimeUnit unit) {
        ShadowLooper.getShadowMainLooper().idle(amount, unit);
    }

    public static void idleMainLooperConstantly(boolean shouldIdleConstantly) {
        ShadowLooper.getShadowMainLooper().idleConstantly(shouldIdleConstantly);
    }

    public static void runMainLooperOneTask() {
        ShadowLooper.getShadowMainLooper().runOneTask();
    }

    public static void runMainLooperToNextTask() {
        ShadowLooper.getShadowMainLooper().runToNextTask();
    }

    public static void runUiThreadTasks() {
        ShadowLooper.getShadowMainLooper().idle();
    }

    public static void runUiThreadTasksIncludingDelayedTasks() {
        ShadowLooper.getShadowMainLooper().runToEndOfTasks();
    }

    public void idle() {
        this.idle(0L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void idle(long intervalMillis) {
        this.idle(intervalMillis, TimeUnit.MILLISECONDS);
    }

    public void idle(long amount, TimeUnit unit) {
        this.getScheduler().advanceBy(amount, unit);
    }

    public void idleConstantly(boolean shouldIdleConstantly) {
        this.getScheduler().idleConstantly(shouldIdleConstantly);
    }

    public void runToEndOfTasks() {
        this.getScheduler().advanceToLastPostedRunnable();
    }

    public void runToNextTask() {
        this.getScheduler().advanceToNextPostedRunnable();
    }

    public void runOneTask() {
        this.getScheduler().runOneTask();
    }

    @Deprecated
    public boolean post(Runnable runnable, long delayMillis) {
        if (!this.quit) {
            this.getScheduler().postDelayed(runnable, delayMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean postAtFrontOfQueue(Runnable runnable) {
        if (!this.quit) {
            this.getScheduler().postAtFrontOfQueue(runnable);
            return true;
        }
        return false;
    }

    public void pause() {
        this.getScheduler().pause();
    }

    public void unPause() {
        this.getScheduler().unPause();
    }

    public boolean isPaused() {
        return this.getScheduler().isPaused();
    }

    public boolean setPaused(boolean shouldPause) {
        boolean wasPaused = this.isPaused();
        if (shouldPause) {
            this.pause();
        } else {
            this.unPause();
        }
        return wasPaused;
    }

    public void resetScheduler() {
        ShadowMessageQueue shadowMessageQueue = ShadowLooper.shadowOf(this.realObject.getQueue());
        if (this.realObject == Looper.getMainLooper() || RoboSettings.isUseGlobalScheduler()) {
            shadowMessageQueue.setScheduler(RuntimeEnvironment.getMasterScheduler());
        } else {
            shadowMessageQueue.setScheduler(new Scheduler());
        }
    }

    public void reset() {
        ShadowLooper.shadowOf(this.realObject.getQueue()).reset();
        this.resetScheduler();
        this.quit = false;
    }

    public Scheduler getScheduler() {
        return ShadowLooper.shadowOf(this.realObject.getQueue()).getScheduler();
    }

    public void runPaused(Runnable r) {
        boolean wasPaused = this.setPaused(true);
        try {
            r.run();
        }
        finally {
            if (!wasPaused) {
                this.unPause();
            }
        }
    }

    private static ShadowLooper shadowOf(Looper looper) {
        return (ShadowLooper)Shadow.extract((Object)looper);
    }

    private static ShadowMessageQueue shadowOf(MessageQueue mq) {
        return (ShadowMessageQueue)Shadow.extract((Object)mq);
    }
}

