/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPlayerBase;
import org.robolectric.shadows.util.DataSource;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaPlayer.class)
public class ShadowMediaPlayer
extends ShadowPlayerBase {
    protected static CreateListener createListener;
    private static final Map<DataSource, Exception> exceptions;
    private static final Map<DataSource, MediaInfo> mediaInfo;
    @RealObject
    private MediaPlayer player;
    private RunList nextPlaybackEvent;
    private State state = State.IDLE;
    private int seekDelay = 0;
    private int auxEffect;
    private int audioSessionId;
    private int audioStreamType;
    private boolean looping;
    private int pendingSeek = -1;
    private Uri sourceUri;
    private int sourceResId;
    private DataSource dataSource;
    private long startTime = -1L;
    private int startOffset = 0;
    private int videoHeight;
    private int videoWidth;
    private float leftVolume;
    private float rightVolume;
    private MediaPlayer.OnCompletionListener completionListener;
    private MediaPlayer.OnSeekCompleteListener seekCompleteListener;
    private MediaPlayer.OnPreparedListener preparedListener;
    private MediaPlayer.OnInfoListener infoListener;
    private MediaPlayer.OnErrorListener errorListener;
    private InvalidStateBehavior invalidStateBehavior = InvalidStateBehavior.SILENT;
    private Handler handler;
    private static final MediaEvent completionCallback;
    private static final MediaEvent preparedCallback;
    private static final MediaEvent seekCompleteCallback;
    private static final ErrorCallback invalidStateErrorCallback;
    public static final int MEDIA_EVENT = 1;
    private static final EnumSet<State> nonEndStates;
    private static final EnumSet<State> nonErrorStates;
    private static EnumSet<State> preparableStates;
    private static EnumSet<State> startableStates;
    private static final EnumSet<State> pausableStates;
    static final EnumSet<State> allStates;
    private static final EnumSet<State> stoppableStates;
    private static final EnumSet<State> attachableStates;
    private static final EnumSet<State> seekableStates;
    private static final EnumSet<State> idleState;
    private static final EnumSet<State> nonPlayingStates;
    private static EnumSet<State> preparedStates;

    @Implementation
    protected static void __staticInitializer__() {
    }

    public void postEvent(MediaEvent e) {
        Message msg = this.handler.obtainMessage(1, (Object)e);
        this.handler.sendMessage(msg);
    }

    public void postEventDelayed(MediaEvent e, long delay) {
        Message msg = this.handler.obtainMessage(1, (Object)e);
        this.handler.sendMessageDelayed(msg, delay);
    }

    @Implementation
    protected static MediaPlayer create(Context context, int resId) {
        MediaPlayer mp = new MediaPlayer();
        ShadowMediaPlayer shadow = (ShadowMediaPlayer)Shadow.extract((Object)mp);
        shadow.sourceResId = resId;
        try {
            shadow.setState(State.INITIALIZED);
            mp.setDataSource("android.resource://" + context.getPackageName() + "/" + resId);
            mp.prepare();
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    @Implementation
    protected static MediaPlayer create(Context context, Uri uri) {
        MediaPlayer mp = new MediaPlayer();
        try {
            mp.setDataSource(context, uri);
            mp.prepare();
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    @Implementation
    protected void __constructor__() {
        Random random = new Random();
        this.audioSessionId = random.nextInt(Integer.MAX_VALUE) + 1;
        Looper myLooper = Looper.myLooper();
        this.handler = myLooper != null ? this.getHandler(myLooper) : this.getHandler(Looper.getMainLooper());
        if (createListener != null) {
            createListener.onCreate(this.player, this);
        }
        Shadow.invokeConstructor(MediaPlayer.class, (Object)this.player, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    private Handler getHandler(Looper looper) {
        return new Handler(looper){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        MediaEvent e = (MediaEvent)msg.obj;
                        e.run(ShadowMediaPlayer.this.player, ShadowMediaPlayer.this);
                        ShadowMediaPlayer.this.scheduleNextPlaybackEvent();
                    }
                }
            }
        };
    }

    public void setDataSource(DataSource dataSource) throws IOException {
        Exception e = exceptions.get(dataSource);
        if (e != null) {
            e.fillInStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new AssertionError((Object)("Invalid exception type for setDataSource: <" + e + '>'));
        }
        this.checkStateException("setDataSource()", idleState);
        this.doSetDataSource(dataSource);
        this.state = State.INITIALIZED;
    }

    public void doSetDataSource(DataSource dataSource) {
        if (mediaInfo.get(dataSource) == null) {
            throw new IllegalArgumentException("Don't know what to do with dataSource " + dataSource + " - either add an exception with addException() or media info with addMediaInfo()");
        }
        this.dataSource = dataSource;
    }

    @Implementation
    protected void setDataSource(String path) throws IOException {
        this.setDataSource(DataSource.toDataSource(path));
    }

    @Implementation
    protected void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        this.setDataSource(DataSource.toDataSource(context, uri, headers));
        this.sourceUri = uri;
    }

    @Implementation
    protected void setDataSource(String uri, Map<String, String> headers) throws IOException {
        this.setDataSource(DataSource.toDataSource(uri, headers));
    }

    @Implementation
    protected void setDataSource(FileDescriptor fd, long offset, long length) throws IOException {
        this.setDataSource(DataSource.toDataSource(fd, offset, length));
    }

    public static MediaInfo getMediaInfo(DataSource dataSource) {
        return mediaInfo.get(dataSource);
    }

    public static void addMediaInfo(DataSource dataSource, MediaInfo info) {
        mediaInfo.put(dataSource, info);
    }

    public static void addException(DataSource dataSource, RuntimeException e) {
        exceptions.put(dataSource, e);
    }

    public static void addException(DataSource dataSource, IOException e) {
        exceptions.put(dataSource, e);
    }

    private void checkStateLog(String method, EnumSet<State> allowedStates) {
        switch (this.invalidStateBehavior) {
            case SILENT: {
                break;
            }
            case EMULATE: {
                if (this.state != State.END) break;
                String msg = "Can't call " + method + " from state " + (Object)((Object)this.state);
                throw new IllegalStateException(msg);
            }
            case ASSERT: {
                if (allowedStates.contains((Object)this.state) && this.state != State.END) break;
                String msg = "Can't call " + method + " from state " + (Object)((Object)this.state);
                throw new AssertionError((Object)msg);
            }
        }
    }

    private boolean checkStateError(String method, EnumSet<State> allowedStates) {
        if (!allowedStates.contains((Object)this.state)) {
            switch (this.invalidStateBehavior) {
                case SILENT: {
                    break;
                }
                case EMULATE: {
                    if (this.state == State.END) {
                        String msg = "Can't call " + method + " from state " + (Object)((Object)this.state);
                        throw new IllegalStateException(msg);
                    }
                    this.state = State.ERROR;
                    this.postEvent(invalidStateErrorCallback);
                    return false;
                }
                case ASSERT: {
                    String msg = "Can't call " + method + " from state " + (Object)((Object)this.state);
                    throw new AssertionError((Object)msg);
                }
            }
        }
        return true;
    }

    private void checkStateException(String method, EnumSet<State> allowedStates) {
        if (!allowedStates.contains((Object)this.state)) {
            String msg = "Can't call " + method + " from state " + (Object)((Object)this.state);
            switch (this.invalidStateBehavior) {
                case SILENT: {
                    break;
                }
                case EMULATE: {
                    throw new IllegalStateException(msg);
                }
                case ASSERT: {
                    throw new AssertionError((Object)msg);
                }
            }
        }
    }

    @Implementation
    protected void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.completionListener = listener;
    }

    @Implementation
    protected void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        this.seekCompleteListener = listener;
    }

    @Implementation
    protected void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.preparedListener = listener;
    }

    @Implementation
    protected void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.infoListener = listener;
    }

    @Implementation
    protected void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.errorListener = listener;
    }

    @Implementation
    protected boolean isLooping() {
        this.checkStateException("isLooping()", nonEndStates);
        return this.looping;
    }

    @Implementation
    protected void setLooping(boolean looping) {
        this.checkStateError("setLooping()", nonErrorStates);
        this.looping = looping;
    }

    @Implementation
    protected void setVolume(float left, float right) {
        this.checkStateError("setVolume()", nonErrorStates);
        this.leftVolume = left;
        this.rightVolume = right;
    }

    @Implementation
    protected boolean isPlaying() {
        this.checkStateError("isPlaying()", nonErrorStates);
        return this.state == State.STARTED;
    }

    @Implementation
    protected void prepare() {
        this.checkStateException("prepare()", preparableStates);
        MediaInfo info = this.getMediaInfo();
        if (info.preparationDelay > 0) {
            SystemClock.sleep((long)info.preparationDelay);
        }
        this.invokePreparedListener();
    }

    @Implementation
    protected void prepareAsync() {
        this.checkStateException("prepareAsync()", preparableStates);
        this.state = State.PREPARING;
        MediaInfo info = this.getMediaInfo();
        if (info.preparationDelay >= 0) {
            this.postEventDelayed(preparedCallback, info.preparationDelay);
        }
    }

    @Implementation
    protected void start() {
        if (this.checkStateError("start()", startableStates)) {
            if (this.state == State.PLAYBACK_COMPLETED) {
                this.startOffset = 0;
            }
            this.state = State.STARTED;
            this.doStart();
        }
    }

    private void scheduleNextPlaybackEvent() {
        if (!this.isReallyPlaying()) {
            return;
        }
        int currentPosition = this.getCurrentPositionRaw();
        MediaInfo info = this.getMediaInfo();
        Map.Entry<Integer, RunList> event = info.events.higherEntry(currentPosition);
        if (event == null) {
            this.postEvent(completionCallback);
        } else {
            int runListOffset = event.getKey();
            this.nextPlaybackEvent = event.getValue();
            this.postEventDelayed(this.nextPlaybackEvent, runListOffset - currentPosition);
        }
    }

    public boolean isReallyPlaying() {
        return this.startTime >= 0L;
    }

    public void doStart() {
        this.startTime = SystemClock.uptimeMillis();
        this.scheduleNextPlaybackEvent();
    }

    public void doStop() {
        this.startOffset = this.getCurrentPositionRaw();
        if (this.nextPlaybackEvent != null) {
            this.handler.removeMessages(1);
            this.nextPlaybackEvent = null;
        }
        this.startTime = -1L;
    }

    @Implementation
    protected void _pause() {
        if (this.checkStateError("pause()", pausableStates)) {
            this.doStop();
            this.state = State.PAUSED;
        }
    }

    @Implementation
    protected void _release() {
        this.checkStateException("release()", allStates);
        this.doStop();
        this.state = State.END;
        this.handler.removeMessages(1);
    }

    @Implementation
    protected void _reset() {
        this.checkStateException("reset()", nonEndStates);
        this.doStop();
        this.state = State.IDLE;
        this.handler.removeMessages(1);
        this.startOffset = 0;
    }

    @Implementation
    protected void _stop() {
        if (this.checkStateError("stop()", stoppableStates)) {
            this.doStop();
            this.state = State.STOPPED;
        }
    }

    @Implementation
    protected void attachAuxEffect(int effectId) {
        this.checkStateError("attachAuxEffect()", attachableStates);
        this.auxEffect = effectId;
    }

    @Implementation
    protected int getAudioSessionId() {
        this.checkStateException("getAudioSessionId()", allStates);
        return this.audioSessionId;
    }

    @Implementation
    protected int getCurrentPosition() {
        this.checkStateError("getCurrentPosition()", attachableStates);
        return this.getCurrentPositionRaw();
    }

    @Implementation
    protected int getDuration() {
        this.checkStateError("getDuration()", stoppableStates);
        return this.getMediaInfo().duration;
    }

    @Implementation
    protected int getVideoHeight() {
        this.checkStateLog("getVideoHeight()", attachableStates);
        return this.videoHeight;
    }

    @Implementation
    protected int getVideoWidth() {
        this.checkStateLog("getVideoWidth()", attachableStates);
        return this.videoWidth;
    }

    @Implementation
    protected void seekTo(int seekTo) {
        this.seekTo(seekTo, 0);
    }

    @Implementation(minSdk=26)
    protected void seekTo(long seekTo, int mode) {
        boolean success = this.checkStateError("seekTo()", seekableStates);
        this.handler.removeMessages(1, (Object)seekCompleteCallback);
        if (success) {
            this.doStop();
            this.pendingSeek = (int)seekTo;
            if (this.seekDelay >= 0) {
                this.postEventDelayed(seekCompleteCallback, this.seekDelay);
            }
        }
    }

    @Implementation
    protected void setAudioSessionId(int sessionId) {
        this.checkStateError("setAudioSessionId()", idleState);
        this.audioSessionId = sessionId;
    }

    @Implementation
    protected void setAudioStreamType(int audioStreamType) {
        this.checkStateError("setAudioStreamType()", nonPlayingStates);
        this.audioStreamType = audioStreamType;
    }

    public static void setCreateListener(CreateListener createListener) {
        ShadowMediaPlayer.createListener = createListener;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public InvalidStateBehavior getInvalidStateBehavior() {
        return this.invalidStateBehavior;
    }

    public void setInvalidStateBehavior(InvalidStateBehavior invalidStateBehavior) {
        this.invalidStateBehavior = invalidStateBehavior;
    }

    public MediaInfo getMediaInfo() {
        return mediaInfo.get(this.dataSource);
    }

    public void setCurrentPosition(int position) {
        this.startOffset = position;
    }

    public int getCurrentPositionRaw() {
        int currentPos = this.startOffset;
        if (this.isReallyPlaying()) {
            currentPos += (int)(SystemClock.uptimeMillis() - this.startTime);
        }
        return currentPos;
    }

    public int getDurationRaw() {
        return this.getMediaInfo().duration;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int getTheAudioStreamType() {
        return this.audioStreamType;
    }

    public int getSeekDelay() {
        return this.seekDelay;
    }

    public void setSeekDelay(int seekDelay) {
        this.seekDelay = seekDelay;
    }

    public int getAuxEffect() {
        return this.auxEffect;
    }

    public int getPendingSeek() {
        return this.pendingSeek;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Uri getSourceUri() {
        return this.sourceUri;
    }

    public int getSourceResId() {
        return this.sourceResId;
    }

    public float getLeftVolume() {
        return this.leftVolume;
    }

    public float getRightVolume() {
        return this.rightVolume;
    }

    public boolean isPrepared() {
        return preparedStates.contains((Object)this.state);
    }

    public MediaPlayer.OnCompletionListener getOnCompletionListener() {
        return this.completionListener;
    }

    public MediaPlayer.OnPreparedListener getOnPreparedListener() {
        return this.preparedListener;
    }

    public void invokePreparedListener() {
        this.state = State.PREPARED;
        if (this.preparedListener == null) {
            return;
        }
        this.preparedListener.onPrepared(this.player);
    }

    public void invokeCompletionListener() {
        this.state = State.PLAYBACK_COMPLETED;
        if (this.completionListener == null) {
            return;
        }
        this.completionListener.onCompletion(this.player);
    }

    public void invokeSeekCompleteListener() {
        int duration = this.getMediaInfo().duration;
        this.setCurrentPosition(this.pendingSeek > duration ? duration : (this.pendingSeek < 0 ? 0 : this.pendingSeek));
        this.pendingSeek = -1;
        if (this.state == State.STARTED) {
            this.doStart();
        }
        if (this.seekCompleteListener == null) {
            return;
        }
        this.seekCompleteListener.onSeekComplete(this.player);
    }

    public void invokeInfoListener(int what, int extra) {
        if (this.infoListener != null) {
            this.infoListener.onInfo(this.player, what, extra);
        }
    }

    public void invokeErrorListener(int what, int extra) {
        boolean handled;
        this.doStop();
        this.state = State.ERROR;
        boolean bl = handled = this.errorListener != null && this.errorListener.onError(this.player, what, extra);
        if (!handled) {
            this.invokeCompletionListener();
            this.state = State.ERROR;
        }
    }

    @Resetter
    public static void resetStaticState() {
        createListener = null;
        exceptions.clear();
        mediaInfo.clear();
    }

    static {
        exceptions = new HashMap<DataSource, Exception>();
        mediaInfo = new HashMap<DataSource, MediaInfo>();
        completionCallback = new MediaEvent(){

            @Override
            public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                if (mp.isLooping()) {
                    smp.startOffset = 0;
                    smp.doStart();
                } else {
                    smp.doStop();
                    smp.invokeCompletionListener();
                }
            }
        };
        preparedCallback = new MediaEvent(){

            @Override
            public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                smp.invokePreparedListener();
            }
        };
        seekCompleteCallback = new MediaEvent(){

            @Override
            public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                smp.invokeSeekCompleteListener();
            }
        };
        invalidStateErrorCallback = new ErrorCallback(-38, 0);
        nonEndStates = EnumSet.complementOf(EnumSet.of(State.END));
        nonErrorStates = EnumSet.complementOf(EnumSet.of(State.ERROR, State.END));
        preparableStates = EnumSet.of(State.INITIALIZED, State.STOPPED);
        startableStates = EnumSet.of(State.PREPARED, State.STARTED, State.PAUSED, State.PLAYBACK_COMPLETED);
        pausableStates = EnumSet.of(State.STARTED, State.PAUSED, State.PLAYBACK_COMPLETED);
        allStates = EnumSet.allOf(State.class);
        stoppableStates = EnumSet.of(State.PREPARED, State.STARTED, State.PAUSED, State.STOPPED, State.PLAYBACK_COMPLETED);
        attachableStates = EnumSet.of(State.INITIALIZED, new State[]{State.PREPARING, State.PREPARED, State.STARTED, State.PAUSED, State.STOPPED, State.PLAYBACK_COMPLETED});
        seekableStates = EnumSet.of(State.PREPARED, State.STARTED, State.PAUSED, State.PLAYBACK_COMPLETED);
        idleState = EnumSet.of(State.IDLE);
        nonPlayingStates = EnumSet.of(State.IDLE, State.INITIALIZED, State.STOPPED);
        preparedStates = EnumSet.of(State.PREPARED, State.STARTED, State.PAUSED, State.PLAYBACK_COMPLETED);
    }

    private static class ErrorCallback
    implements MediaEvent {
        private int what;
        private int extra;

        public ErrorCallback(int what, int extra) {
            this.what = what;
            this.extra = extra;
        }

        @Override
        public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
            smp.invokeErrorListener(this.what, this.extra);
        }
    }

    public static interface CreateListener {
        public void onCreate(MediaPlayer var1, ShadowMediaPlayer var2);
    }

    public static class MediaInfo {
        public int duration;
        private int preparationDelay;
        public TreeMap<Integer, RunList> events = new TreeMap();

        public MediaInfo() {
            this(1000, 0);
        }

        public MediaInfo(int duration, int preparationDelay) {
            this.duration = duration;
            this.preparationDelay = preparationDelay;
            this.scheduleEventAtOffset(duration, completionCallback);
        }

        public int getPreparationDelay() {
            return this.preparationDelay;
        }

        public void setPreparationDelay(int preparationDelay) {
            this.preparationDelay = preparationDelay;
        }

        public void scheduleEventAtOffset(int offset, MediaEvent event) {
            RunList runList = this.events.get(offset);
            if (runList == null) {
                runList = new RunList();
                this.events.put(offset, runList);
            }
            runList.add(event);
        }

        public MediaEvent scheduleErrorAtOffset(int offset, int what, int extra) {
            ErrorCallback callback = new ErrorCallback(what, extra);
            this.scheduleEventAtOffset(offset, callback);
            return callback;
        }

        public MediaEvent scheduleInfoAtOffset(int offset, final int what, final int extra) {
            MediaEvent callback = new MediaEvent(){

                @Override
                public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                    smp.invokeInfoListener(what, extra);
                }
            };
            this.scheduleEventAtOffset(offset, callback);
            return callback;
        }

        public MediaEvent scheduleBufferUnderrunAtOffset(int offset, final int length) {
            final MediaEvent restart = new MediaEvent(){

                @Override
                public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                    smp.invokeInfoListener(702, 0);
                    smp.doStart();
                }
            };
            MediaEvent callback = new MediaEvent(){

                @Override
                public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
                    smp.doStop();
                    smp.invokeInfoListener(701, 0);
                    smp.postEventDelayed(restart, length);
                }
            };
            this.scheduleEventAtOffset(offset, callback);
            return callback;
        }

        public void removeEventAtOffset(int offset, MediaEvent event) {
            RunList runList = this.events.get(offset);
            if (runList != null) {
                runList.remove(event);
                if (runList.isEmpty()) {
                    this.events.remove(offset);
                }
            }
        }

        public void removeEvent(MediaEvent event) {
            Iterator<Map.Entry<Integer, RunList>> iter = this.events.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, RunList> entry = iter.next();
                RunList runList = entry.getValue();
                runList.remove(event);
                if (!runList.isEmpty()) continue;
                iter.remove();
            }
        }
    }

    public static interface MediaEvent {
        public void run(MediaPlayer var1, ShadowMediaPlayer var2);
    }

    private static class RunList
    extends ArrayList<MediaEvent>
    implements MediaEvent {
        public RunList() {
            super(1);
        }

        @Override
        public void run(MediaPlayer mp, ShadowMediaPlayer smp) {
            for (MediaEvent e : this) {
                e.run(mp, smp);
            }
        }
    }

    public static enum InvalidStateBehavior {
        SILENT,
        EMULATE,
        ASSERT;

    }

    public static enum State {
        IDLE,
        INITIALIZED,
        PREPARING,
        PREPARED,
        STARTED,
        STOPPED,
        PAUSED,
        PLAYBACK_COMPLETED,
        END,
        ERROR;

    }
}

