/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Messenger.class)
public class ShadowMessenger {
    private static Message lastMessageSent = null;
    @RealObject
    private Messenger messenger;
    private Handler handler;

    public static Message getLastMessageSent() {
        return lastMessageSent;
    }

    public static void clearLastMessageSent() {
        lastMessageSent = null;
    }

    @Implementation
    protected void __constructor__(Handler handler) {
        this.handler = handler;
        Object target = ReflectionHelpers.callInstanceMethod((Object)handler, (String)"getIMessenger", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ReflectionHelpers.setField((Object)this.messenger, (String)"mTarget", (Object)target);
    }

    @Implementation
    protected void __constructor__(IBinder target) {
        if (target != null && target instanceof FakeBinder) {
            this.handler = ((FakeBinder)target).handler;
        }
    }

    @Implementation
    protected void send(Message message) throws RemoteException {
        lastMessageSent = message;
        message.setTarget(this.handler);
        message.sendToTarget();
    }

    @Implementation
    protected IBinder getBinder() {
        return new FakeBinder(this.handler);
    }

    private static class FakeBinder
    extends Binder {
        final Handler handler;

        public FakeBinder(Handler handler) {
            this.handler = handler;
        }
    }
}

