/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ResourceHelper;
import org.robolectric.shadows.ShadowView;

@Implements(value=Notification.class)
@SuppressLint(value={"NewApi"})
public class ShadowNotification {
    @RealObject
    Notification realNotification;

    public CharSequence getContentTitle() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getCharSequence("android.title") : this.findText(this.applyContentView(), "title");
    }

    public CharSequence getContentText() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getCharSequence("android.text") : this.findText(this.applyContentView(), "text");
    }

    public CharSequence getContentInfo() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return this.realNotification.extras.getCharSequence("android.infoText");
        }
        return this.findText(this.applyContentView(), "info");
    }

    public boolean isOngoing() {
        return (this.realNotification.flags & 2) == 2;
    }

    public CharSequence getBigText() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return this.realNotification.extras.getCharSequence("android.bigText");
        }
        return this.findText(this.applyBigContentView(), "big_text");
    }

    public CharSequence getBigContentTitle() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return this.realNotification.extras.getCharSequence("android.title.big");
        }
        return this.findText(this.applyBigContentView(), "title");
    }

    public CharSequence getBigContentText() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return this.realNotification.extras.getCharSequence("android.summaryText");
        }
        return this.findText(this.applyBigContentView(), "text");
    }

    public Bitmap getBigPicture() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return (Bitmap)this.realNotification.extras.getParcelable("android.picture");
        }
        ImageView imageView = (ImageView)this.applyBigContentView().findViewById(ResourceHelper.getInternalResourceId("big_picture"));
        return imageView != null && imageView.getDrawable() != null ? ((BitmapDrawable)imageView.getDrawable()).getBitmap() : null;
    }

    public boolean isWhenShown() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getBoolean("android.showWhen") : this.findView(this.applyContentView(), "chronometer").getVisibility() == 0 || this.findView(this.applyContentView(), "time").getVisibility() == 0;
    }

    private ProgressBar getProgressBar_PreN() {
        return (ProgressBar)this.findView(this.applyContentView(), "progress");
    }

    public boolean isIndeterminate() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getBoolean("android.progressIndeterminate") : this.getProgressBar_PreN().isIndeterminate();
    }

    public int getMax() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getInt("android.progressMax") : this.getProgressBar_PreN().getMax();
    }

    public int getProgress() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getInt("android.progress") : this.getProgressBar_PreN().getProgress();
    }

    public boolean usesChronometer() {
        return RuntimeEnvironment.getApiLevel() >= 24 ? this.realNotification.extras.getBoolean("android.showChronometer") : this.findView(this.applyContentView(), "chronometer").getVisibility() == 0;
    }

    private View applyContentView() {
        return this.realNotification.contentView.apply((Context)RuntimeEnvironment.application, (ViewGroup)new FrameLayout((Context)RuntimeEnvironment.application));
    }

    private View applyBigContentView() {
        return this.realNotification.bigContentView.apply((Context)RuntimeEnvironment.application, (ViewGroup)new FrameLayout((Context)RuntimeEnvironment.application));
    }

    private CharSequence findText(View view, String resourceName) {
        TextView textView = (TextView)this.findView(view, resourceName);
        return textView.getText();
    }

    private View findView(View view, String resourceName) {
        View subView = view.findViewById(ResourceHelper.getInternalResourceId(resourceName));
        if (subView == null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            ShadowView shadowView = (ShadowView)Shadow.extract((Object)view);
            shadowView.dump(new PrintStream(buf), 4);
            throw new IllegalArgumentException("no id." + resourceName + " found in view:\n" + buf.toString());
        }
        return subView;
    }
}

