/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.PatternMatcher;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowResolveInfo;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;

@Implements(value=PackageManager.class)
public class ShadowPackageManager {
    static Map<String, Boolean> permissionRationaleMap = new HashMap<String, Boolean>();
    static List<FeatureInfo> systemAvailableFeatures = new ArrayList<FeatureInfo>();
    static final List<String> systemSharedLibraryNames = new ArrayList<String>();
    static final Map<String, PackageInfo> packageInfos = new LinkedHashMap<String, PackageInfo>();
    static final Map<String, PackageParser.Package> packages = new LinkedHashMap<String, PackageParser.Package>();
    private static Map<String, PackageInfo> packageArchiveInfo = new HashMap<String, PackageInfo>();
    static final Map<String, PackageStats> packageStatsMap = new HashMap<String, PackageStats>();
    static final Map<String, String> packageInstallerMap = new HashMap<String, String>();
    static final Map<Integer, String[]> packagesForUid = new HashMap<Integer, String[]>();
    static final Map<String, Integer> uidForPackage = new HashMap<String, Integer>();
    static final Map<Integer, String> namesForUid = new HashMap<Integer, String>();
    static final Map<Integer, Integer> verificationResults = new HashMap<Integer, Integer>();
    static final Map<Integer, Long> verificationTimeoutExtension = new HashMap<Integer, Long>();
    static final Map<String, String> currentToCanonicalNames = new HashMap<String, String>();
    static final Map<ComponentName, ComponentState> componentList = new LinkedHashMap<ComponentName, ComponentState>();
    static final Map<ComponentName, Drawable> drawableList = new LinkedHashMap<ComponentName, Drawable>();
    static final Map<String, Drawable> applicationIcons = new HashMap<String, Drawable>();
    static final Map<String, Drawable> unbadgedApplicationIcons = new HashMap<String, Drawable>();
    static final Map<String, Boolean> systemFeatureList = new LinkedHashMap<String, Boolean>();
    static final Map<IntentFilterWrapper, ComponentName> preferredActivities = new LinkedHashMap<IntentFilterWrapper, ComponentName>();
    static final Map<Pair<String, Integer>, Drawable> drawables = new LinkedHashMap<Pair<String, Integer>, Drawable>();
    static final Map<String, Integer> applicationEnabledSettingMap = new HashMap<String, Integer>();
    static Map<String, PermissionInfo> extraPermissions = new HashMap<String, PermissionInfo>();
    static Map<String, PermissionGroupInfo> extraPermissionGroups = new HashMap<String, PermissionGroupInfo>();
    public static Map<String, Resources> resources = new HashMap<String, Resources>();
    private static final Map<Intent, List<ResolveInfo>> resolveInfoForIntent = new TreeMap<Intent, List<ResolveInfo>>(new IntentComparator());
    private static Set<String> deletedPackages = new HashSet<String>();
    static Map<String, IPackageDeleteObserver> pendingDeleteCallbacks = new HashMap<String, IPackageDeleteObserver>();
    static Set<String> hiddenPackages = new HashSet<String>();
    static Multimap<Integer, String> sequenceNumberChangedPackagesMap = HashMultimap.create();
    static boolean canRequestPackageInstalls = false;
    static final Map<String, PackageSetting> packageSettings = new HashMap<String, PackageSetting>();

    static int compareSignature(Signature[] signatures1, Signature[] signatures2) {
        HashSet<Signature> signatures2set;
        if (signatures1 == null) {
            return signatures2 == null ? 1 : -1;
        }
        if (signatures2 == null) {
            return -2;
        }
        if (signatures1.length != signatures2.length) {
            return -3;
        }
        HashSet<Signature> signatures1set = new HashSet<Signature>(Arrays.asList(signatures1));
        return signatures1set.equals(signatures2set = new HashSet<Signature>(Arrays.asList(signatures2))) ? 0 : -3;
    }

    static String resolvePackageName(String packageName, ComponentName componentName) {
        String classString = componentName.getClassName();
        int index = classString.indexOf(46);
        if (index == -1) {
            classString = packageName + "." + classString;
        } else if (index == 0) {
            classString = packageName + classString;
        }
        return classString;
    }

    private static void setUpPackageStorage(ApplicationInfo applicationInfo) {
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        if (applicationInfo.sourceDir == null) {
            applicationInfo.sourceDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-sourceDir").toAbsolutePath().toString();
        }
        if (applicationInfo.dataDir == null) {
            applicationInfo.dataDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-dataDir").toAbsolutePath().toString();
        }
        applicationInfo.publicSourceDir = applicationInfo.sourceDir;
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            applicationInfo.credentialProtectedDataDir = tempDirectory.createIfNotExists("userDataDir").toAbsolutePath().toString();
            applicationInfo.deviceProtectedDataDir = tempDirectory.createIfNotExists("deviceDataDir").toAbsolutePath().toString();
        }
    }

    public void setResolveInfosForIntent(Intent intent, List<ResolveInfo> info) {
        resolveInfoForIntent.remove(intent);
        for (ResolveInfo resolveInfo : info) {
            this.addResolveInfoForIntent(intent, resolveInfo);
        }
    }

    @Deprecated
    public void addResolveInfoForIntent(Intent intent, List<ResolveInfo> info) {
        this.setResolveInfosForIntent(intent, info);
    }

    public void addResolveInfoForIntent(Intent intent, ResolveInfo info) {
        ComponentInfo[] componentInfos;
        info.isDefault = true;
        for (ComponentInfo component : componentInfos = new ComponentInfo[]{info.activityInfo, info.serviceInfo, Build.VERSION.SDK_INT >= 19 ? info.providerInfo : null}) {
            if (component == null || component.applicationInfo == null) continue;
            component.applicationInfo.flags |= 0x800000;
        }
        this.addResolveInfoForIntentNoDefaults(intent, info);
    }

    public void addResolveInfoForIntentNoDefaults(Intent intent, ResolveInfo info) {
        Preconditions.checkNotNull((Object)info);
        List<ResolveInfo> infoList = resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            resolveInfoForIntent.put(intent, infoList);
        }
        infoList.add(info);
    }

    public void removeResolveInfosForIntent(Intent intent, String packageName) {
        List<ResolveInfo> infoList = resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            resolveInfoForIntent.put(intent, infoList);
        }
        Iterator<ResolveInfo> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            ResolveInfo resolveInfo = iterator.next();
            if (!ShadowPackageManager.getPackageName(resolveInfo).equals(packageName)) continue;
            iterator.remove();
        }
    }

    private static String getPackageName(ResolveInfo resolveInfo) {
        if (resolveInfo.resolvePackageName != null) {
            return resolveInfo.resolvePackageName;
        }
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.packageName;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo.packageName;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo.packageName;
        }
        throw new IllegalStateException("Could not find package name for ResolveInfo " + resolveInfo.toString());
    }

    public void addActivityIcon(ComponentName component, Drawable drawable2) {
        drawableList.put(component, drawable2);
    }

    public void addActivityIcon(Intent intent, Drawable drawable2) {
        drawableList.put(intent.getComponent(), drawable2);
    }

    public void setApplicationIcon(String packageName, Drawable drawable2) {
        applicationIcons.put(packageName, drawable2);
    }

    public void setUnbadgedApplicationIcon(String packageName, Drawable drawable2) {
        unbadgedApplicationIcons.put(packageName, drawable2);
    }

    public int getComponentEnabledSettingFlags(ComponentName componentName) {
        ComponentState state = componentList.get(componentName);
        return state != null ? state.flags : 0;
    }

    @Deprecated
    public void addPackage(String packageName) {
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = packageName;
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = packageName;
        ShadowPackageManager.setUpPackageStorage(applicationInfo);
        packageInfo.applicationInfo = applicationInfo;
        this.addPackage(packageInfo);
    }

    public void addPackage(PackageInfo packageInfo) {
        ComponentInfo[][] componentInfoArrays;
        ApplicationInfo appInfo = packageInfo.applicationInfo;
        if (appInfo == null) {
            appInfo = new ApplicationInfo();
            appInfo.packageName = packageInfo.packageName;
            packageInfo.applicationInfo = appInfo;
        }
        appInfo.flags |= 0x800000;
        for (ComponentInfo[] componentInfos : componentInfoArrays = new ComponentInfo[][]{packageInfo.activities, packageInfo.services, packageInfo.providers, packageInfo.receivers}) {
            if (componentInfos == null) continue;
            for (ComponentInfo componentInfo : componentInfos) {
                if (componentInfo.applicationInfo == null) {
                    componentInfo.applicationInfo = appInfo;
                }
                componentInfo.applicationInfo.flags |= 0x800000;
            }
        }
        this.addPackageNoDefaults(packageInfo);
    }

    public void addPackageNoDefaults(PackageInfo packageInfo) {
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        this.addPackage(packageInfo, packageStats);
    }

    public void addPackage(PackageInfo packageInfo, PackageStats packageStats) {
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        packageInfos.put(packageInfo.packageName, packageInfo);
        packageStatsMap.put(packageInfo.packageName, packageStats);
        packageSettings.put(packageInfo.packageName, new PackageSetting());
        applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        if (packageInfo.applicationInfo != null) {
            namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public PackageInfo getInternalMutablePackageInfo(String packageName) {
        return packageInfos.get(packageName);
    }

    @Deprecated
    public PackageInfo getPackageInfoForTesting(String packageName) {
        return this.getInternalMutablePackageInfo(packageName);
    }

    public void addPermissionInfo(PermissionInfo permissionInfo) {
        extraPermissions.put(permissionInfo.name, permissionInfo);
    }

    public void addChangedPackage(int sequenceNumber, String packageName) {
        if (sequenceNumber < 0) {
            return;
        }
        sequenceNumberChangedPackagesMap.put((Object)sequenceNumber, (Object)packageName);
    }

    public void addPermissionGroupInfo(PermissionGroupInfo permissionGroupInfo) {
        extraPermissionGroups.put(permissionGroupInfo.name, permissionGroupInfo);
    }

    public void removePackage(String packageName) {
        packages.remove(packageName);
        packageInfos.remove(packageName);
        packageSettings.remove(packageName);
    }

    public void setSystemFeature(String name, boolean supported) {
        systemFeatureList.put(name, supported);
    }

    public void addDrawableResolution(String packageName, int resourceId, Drawable drawable2) {
        drawables.put((Pair<String, Integer>)new Pair((Object)packageName, (Object)resourceId), drawable2);
    }

    public void setNameForUid(int uid, String name) {
        namesForUid.put(uid, name);
    }

    public void setPackagesForCallingUid(String ... packagesForCallingUid) {
        packagesForUid.put(Binder.getCallingUid(), packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            uidForPackage.put(packageName, Binder.getCallingUid());
        }
    }

    public void setPackagesForUid(int uid, String ... packagesForCallingUid) {
        packagesForUid.put(uid, packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            uidForPackage.put(packageName, uid);
        }
    }

    @Implementation
    protected String[] getPackagesForUid(int uid) {
        return packagesForUid.get(uid);
    }

    public void setPackageArchiveInfo(String archiveFilePath, PackageInfo packageInfo) {
        packageArchiveInfo.put(archiveFilePath, packageInfo);
    }

    public int getVerificationResult(int id2) {
        Integer result = verificationResults.get(id2);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public long getVerificationExtendedTimeout(int id2) {
        Long result = verificationTimeoutExtension.get(id2);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public void setShouldShowRequestPermissionRationale(String permission2, boolean show) {
        permissionRationaleMap.put(permission2, show);
    }

    public void addSystemAvailableFeature(FeatureInfo featureInfo) {
        systemAvailableFeatures.add(featureInfo);
    }

    public void clearSystemAvailableFeatures() {
        systemAvailableFeatures.clear();
    }

    public void addSystemSharedLibraryName(String name) {
        systemSharedLibraryNames.add(name);
    }

    public void clearSystemSharedLibraryNames() {
        systemSharedLibraryNames.clear();
    }

    public void addCurrentToCannonicalName(String currentName, String canonicalName) {
        currentToCanonicalNames.put(currentName, canonicalName);
    }

    public void setCanRequestPackageInstalls(boolean canRequestPackageInstalls) {
        ShadowPackageManager.canRequestPackageInstalls = canRequestPackageInstalls;
    }

    @Implementation(minSdk=24)
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, UserHandle userHandle) {
        return null;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192) continue;
            result.add(packageInfo);
        }
        ArrayList<PackageInfo> packages = result;
        for (PackageInfo aPackage : packages) {
            ApplicationInfo appInfo = aPackage.applicationInfo;
            if (appInfo == null || !archiveFilePath.equals(appInfo.sourceDir)) continue;
            return aPackage;
        }
        return null;
    }

    @Implementation
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void freeStorage(long freeStorageSize, IntentSender pi) {
    }

    public void doPendingUninstallCallbacks() {
        boolean hasDeletePackagesPermission = false;
        String[] requestedPermissions = ShadowPackageManager.packageInfos.get((Object)RuntimeEnvironment.application.getPackageName()).requestedPermissions;
        if (requestedPermissions != null) {
            for (String permission2 : requestedPermissions) {
                if (!"android.permission.DELETE_PACKAGES".equals(permission2)) continue;
                hasDeletePackagesPermission = true;
                break;
            }
        }
        for (String packageName : pendingDeleteCallbacks.keySet()) {
            int resultCode = -1;
            PackageInfo removed = packageInfos.get(packageName);
            if (hasDeletePackagesPermission && removed != null) {
                packageInfos.remove(packageName);
                packageSettings.remove(packageName);
                deletedPackages.add(packageName);
                resultCode = 1;
            }
            try {
                pendingDeleteCallbacks.get(packageName).packageDeleted(packageName, resultCode);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
        pendingDeleteCallbacks.clear();
    }

    public Set<String> getDeletedPackages() {
        return deletedPackages;
    }

    protected List<ResolveInfo> queryOverriddenIntents(Intent intent, int flags) {
        List<ResolveInfo> overrides = resolveInfoForIntent.get(intent);
        if (overrides == null) {
            return Collections.emptyList();
        }
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>(overrides.size());
        for (ResolveInfo resolveInfo : overrides) {
            result.add(ShadowResolveInfo.newResolveInfo(resolveInfo));
        }
        return result;
    }

    public void addPackageInternal(PackageParser.Package appPackage) {
        int flags = 851967;
        packages.put(appPackage.packageName, appPackage);
        PackageInfo packageInfo = RuntimeEnvironment.getApiLevel() >= 23 ? PackageParser.generatePackageInfo((PackageParser.Package)appPackage, (int[])new int[]{0}, (int)flags, (long)0L, (long)0L, new HashSet(), (PackageUserState)new PackageUserState()) : (RuntimeEnvironment.getApiLevel() >= 22 ? (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(ArraySet.class, (Object)new ArraySet()), ReflectionHelpers.ClassParameter.from(PackageUserState.class, (Object)new PackageUserState())}) : (RuntimeEnvironment.getApiLevel() >= 17 ? (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(HashSet.class, new HashSet()), ReflectionHelpers.ClassParameter.from(PackageUserState.class, (Object)new PackageUserState())}) : (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(HashSet.class, new HashSet())})));
        packageInfo.applicationInfo.uid = Process.myUid();
        packageInfo.applicationInfo.dataDir = RuntimeEnvironment.getTempDirectory().createIfNotExists(packageInfo.packageName + "-dataDir").toString();
        this.addPackage(packageInfo);
    }

    public List<IntentFilter> getIntentFiltersForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(ShadowPackageManager.getAppPackage((ComponentName)componentName).activities, componentName);
    }

    public List<IntentFilter> getIntentFiltersForService(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(ShadowPackageManager.getAppPackage((ComponentName)componentName).services, componentName);
    }

    public List<IntentFilter> getIntentFiltersForReceiver(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(ShadowPackageManager.getAppPackage((ComponentName)componentName).receivers, componentName);
    }

    private static List<IntentFilter> getIntentFiltersForComponent(List<? extends PackageParser.Component> components, ComponentName componentName) throws PackageManager.NameNotFoundException {
        for (PackageParser.Component component : components) {
            if (!component.getComponentName().equals((Object)componentName)) continue;
            return component.intents;
        }
        throw new PackageManager.NameNotFoundException("unknown component " + componentName);
    }

    private static PackageParser.Package getAppPackage(ComponentName componentName) throws PackageManager.NameNotFoundException {
        PackageParser.Package appPackage = packages.get(componentName.getPackageName());
        if (appPackage == null) {
            throw new PackageManager.NameNotFoundException("unknown package " + componentName.getPackageName());
        }
        return appPackage;
    }

    public PackageSetting getPackageSetting(String packageName) {
        PackageSetting setting = packageSettings.get(packageName);
        return setting == null ? null : new PackageSetting(setting);
    }

    @Resetter
    public static void reset() {
        permissionRationaleMap.clear();
        systemAvailableFeatures.clear();
        systemSharedLibraryNames.clear();
        packageInfos.clear();
        packages.clear();
        packageArchiveInfo.clear();
        packageStatsMap.clear();
        packageInstallerMap.clear();
        packagesForUid.clear();
        uidForPackage.clear();
        namesForUid.clear();
        verificationResults.clear();
        verificationTimeoutExtension.clear();
        currentToCanonicalNames.clear();
        componentList.clear();
        drawableList.clear();
        applicationIcons.clear();
        unbadgedApplicationIcons.clear();
        systemFeatureList.clear();
        preferredActivities.clear();
        drawables.clear();
        applicationEnabledSettingMap.clear();
        extraPermissions.clear();
        extraPermissionGroups.clear();
        resources.clear();
        resolveInfoForIntent.clear();
        deletedPackages.clear();
        pendingDeleteCallbacks.clear();
        hiddenPackages.clear();
        sequenceNumberChangedPackagesMap.clear();
        packageSettings.clear();
    }

    protected static class ComponentState {
        public int newState;
        public int flags;

        public ComponentState(int newState, int flags) {
            this.newState = newState;
            this.flags = flags;
        }
    }

    static class ResolveInfoComparator
    implements Comparator<ResolveInfo> {
        private final HashSet<ComponentName> preferredComponents;

        public ResolveInfoComparator(HashSet<ComponentName> preferredComponents) {
            this.preferredComponents = preferredComponents;
        }

        @Override
        public int compare(ResolveInfo o1, ResolveInfo o2) {
            boolean o2isPreferred;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            boolean o1isPreferred = this.isPreferred(o1);
            if (o1isPreferred != (o2isPreferred = this.isPreferred(o2))) {
                return Boolean.compare(o1isPreferred, o2isPreferred);
            }
            if (o1.preferredOrder != o2.preferredOrder) {
                return Integer.compare(o1.preferredOrder, o2.preferredOrder);
            }
            if (o1.priority != o2.priority) {
                return Integer.compare(o1.priority, o2.priority);
            }
            return 0;
        }

        private boolean isPreferred(ResolveInfo resolveInfo) {
            return resolveInfo.activityInfo != null && resolveInfo.activityInfo.packageName != null && resolveInfo.activityInfo.name != null && this.preferredComponents.contains(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name));
        }
    }

    protected static class IntentFilterWrapper {
        final IntentFilter filter;
        private final HashSet<String> actions = new HashSet();
        private HashSet<String> categories = new HashSet();
        private HashSet<String> dataSchemes = new HashSet();
        private HashSet<String> dataSchemeSpecificParts = new HashSet();
        private HashSet<String> dataAuthorities = new HashSet();
        private HashSet<String> dataPaths = new HashSet();
        private HashSet<String> dataTypes = new HashSet();

        public IntentFilterWrapper(IntentFilter filter) {
            int i;
            this.filter = filter;
            if (filter == null) {
                return;
            }
            for (i = 0; i < filter.countActions(); ++i) {
                this.actions.add(filter.getAction(i));
            }
            for (i = 0; i < filter.countCategories(); ++i) {
                this.categories.add(filter.getCategory(i));
            }
            for (i = 0; i < filter.countDataAuthorities(); ++i) {
                IntentFilter.AuthorityEntry dataAuthority = filter.getDataAuthority(i);
                this.dataAuthorities.add(dataAuthority.getHost() + ":" + dataAuthority.getPort());
            }
            for (i = 0; i < filter.countDataPaths(); ++i) {
                PatternMatcher dataPath = filter.getDataPath(i);
                this.dataPaths.add(dataPath.toString());
            }
            for (i = 0; i < filter.countDataSchemes(); ++i) {
                this.dataSchemes.add(filter.getDataScheme(i));
            }
            if (Build.VERSION.SDK_INT >= 19) {
                for (i = 0; i < filter.countDataSchemeSpecificParts(); ++i) {
                    this.dataSchemeSpecificParts.add(filter.getDataSchemeSpecificPart(i).toString());
                }
            }
            for (i = 0; i < filter.countDataTypes(); ++i) {
                this.dataTypes.add(filter.getDataType(i));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntentFilterWrapper)) {
                return false;
            }
            IntentFilterWrapper that = (IntentFilterWrapper)o;
            if (this.filter == null && that.filter == null) {
                return true;
            }
            if (this.filter == null || that.filter == null) {
                return false;
            }
            return this.filter.getPriority() == that.filter.getPriority() && Objects.equals(this.actions, that.actions) && Objects.equals(this.categories, that.categories) && Objects.equals(this.dataSchemes, that.dataSchemes) && Objects.equals(this.dataSchemeSpecificParts, that.dataSchemeSpecificParts) && Objects.equals(this.dataAuthorities, that.dataAuthorities) && Objects.equals(this.dataPaths, that.dataPaths) && Objects.equals(this.dataTypes, that.dataTypes);
        }

        public int hashCode() {
            return Objects.hash(this.filter == null ? null : Integer.valueOf(this.filter.getPriority()), this.actions, this.categories, this.dataSchemes, this.dataSchemeSpecificParts, this.dataAuthorities, this.dataPaths, this.dataTypes);
        }

        public IntentFilter getFilter() {
            return this.filter;
        }
    }

    public static class IntentComparator
    implements Comparator<Intent> {
        @Override
        public int compare(Intent i1, Intent i2) {
            if (i1 == null && i2 == null) {
                return 0;
            }
            if (i1 == null && i2 != null) {
                return -1;
            }
            if (i1 != null && i2 == null) {
                return 1;
            }
            if (i1.equals(i2)) {
                return 0;
            }
            String action1 = i1.getAction();
            String action2 = i2.getAction();
            if (action1 == null && action2 != null) {
                return -1;
            }
            if (action1 != null && action2 == null) {
                return 1;
            }
            if (action1 != null && action2 != null && !action1.equals(action2)) {
                return action1.compareTo(action2);
            }
            Uri data1 = i1.getData();
            Uri data2 = i2.getData();
            if (data1 == null && data2 != null) {
                return -1;
            }
            if (data1 != null && data2 == null) {
                return 1;
            }
            if (data1 != null && data2 != null && !data1.equals((Object)data2)) {
                return data1.compareTo(data2);
            }
            ComponentName component1 = i1.getComponent();
            ComponentName component2 = i2.getComponent();
            if (component1 == null && component2 != null) {
                return -1;
            }
            if (component1 != null && component2 == null) {
                return 1;
            }
            if (component1 != null && component2 != null && !component1.equals((Object)component2)) {
                return component1.compareTo(component2);
            }
            String package1 = i1.getPackage();
            String package2 = i2.getPackage();
            if (package1 == null && package2 != null) {
                return -1;
            }
            if (package1 != null && package2 == null) {
                return 1;
            }
            if (package1 != null && package2 != null && !package1.equals(package2)) {
                return package1.compareTo(package2);
            }
            Set categories1 = i1.getCategories();
            Set categories2 = i2.getCategories();
            if (categories1 == null) {
                return categories2 == null ? 0 : -1;
            }
            if (categories2 == null) {
                return 1;
            }
            if (categories1.size() > categories2.size()) {
                return 1;
            }
            if (categories1.size() < categories2.size()) {
                return -1;
            }
            Object[] array1 = categories1.toArray(new String[0]);
            Object[] array2 = categories2.toArray(new String[0]);
            Arrays.sort(array1);
            Arrays.sort(array2);
            for (int i = 0; i < array1.length; ++i) {
                int val = ((String)array1[i]).compareTo((String)array2[i]);
                if (val == 0) continue;
                return val;
            }
            return 0;
        }
    }

    public static class PackageSetting {
        private boolean suspended = false;
        private String dialogMessage = null;
        private PersistableBundle suspendedAppExtras = null;
        private PersistableBundle suspendedLauncherExtras = null;

        public PackageSetting() {
        }

        public PackageSetting(PackageSetting that) {
            this.suspended = that.suspended;
            this.dialogMessage = that.dialogMessage;
            this.suspendedAppExtras = PackageSetting.deepCopyNullablePersistableBundle(that.suspendedAppExtras);
            this.suspendedLauncherExtras = PackageSetting.deepCopyNullablePersistableBundle(that.suspendedLauncherExtras);
        }

        void setSuspended(boolean suspended, String dialogMessage, PersistableBundle appExtras, PersistableBundle launcherExtras) {
            this.suspended = suspended;
            this.dialogMessage = suspended ? dialogMessage : null;
            this.suspendedAppExtras = suspended ? PackageSetting.deepCopyNullablePersistableBundle(appExtras) : null;
            this.suspendedLauncherExtras = suspended ? PackageSetting.deepCopyNullablePersistableBundle(launcherExtras) : null;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public String getDialogMessage() {
            return this.dialogMessage;
        }

        public PersistableBundle getSuspendedAppExtras() {
            return this.suspendedAppExtras;
        }

        public PersistableBundle getSuspendedLauncherExtras() {
            return this.suspendedLauncherExtras;
        }

        private static PersistableBundle deepCopyNullablePersistableBundle(PersistableBundle bundle) {
            return bundle == null ? null : bundle.deepCopy();
        }
    }
}

