/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.PackageParser;
import android.util.DisplayMetrics;
import java.io.File;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.res.FsFile;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=PackageParser.class, isInAndroidSdk=false)
public class ShadowPackageParser {
    public static PackageParser.Package callParsePackage(FsFile apkFile) {
        PackageParser packageParser = new PackageParser();
        int flags = 2;
        try {
            PackageParser.Package thePackage = RuntimeEnvironment.getApiLevel() >= 21 ? packageParser.parsePackage(new File(apkFile.getPath()), flags) : (PackageParser.Package)ReflectionHelpers.callInstanceMethod(PackageParser.class, (Object)packageParser, (String)"parsePackage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(File.class, (Object)new File(apkFile.getPath())), ReflectionHelpers.ClassParameter.from(String.class, (Object)apkFile.getPath()), ReflectionHelpers.ClassParameter.from(DisplayMetrics.class, (Object)new DisplayMetrics()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags)});
            if (thePackage == null) {
                List<ShadowLog.LogItem> logItems = ShadowLog.getLogsForTag("PackageParser");
                if (logItems.isEmpty()) {
                    throw new RuntimeException("Failed to parse package " + apkFile);
                }
                ShadowLog.LogItem logItem = logItems.get(0);
                throw new RuntimeException("Failed to parse package " + apkFile + ": " + logItem.msg, logItem.throwable);
            }
            return thePackage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

