/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowContextWrapper;

@Implements(value=Service.class)
public class ShadowService
extends ShadowContextWrapper {
    @RealObject
    Service realService;
    private int lastForegroundNotificationId;
    private Notification lastForegroundNotification;
    private boolean selfStopped = false;
    private boolean foregroundStopped;
    private boolean notificationShouldRemoved;
    private int stopSelfId;
    private int stopSelfResultId;

    @Implementation
    protected void onDestroy() {
        this.removeForegroundNotification();
    }

    @Implementation
    protected void stopSelf() {
        this.selfStopped = true;
    }

    @Implementation
    protected void stopSelf(int id2) {
        this.selfStopped = true;
        this.stopSelfId = id2;
    }

    @Implementation
    protected boolean stopSelfResult(int id2) {
        this.selfStopped = true;
        this.stopSelfResultId = id2;
        return true;
    }

    @Implementation
    protected final void startForeground(int id2, Notification notification) {
        this.foregroundStopped = false;
        this.lastForegroundNotificationId = id2;
        this.lastForegroundNotification = notification;
        notification.flags |= 0x40;
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.application.getSystemService("notification");
        nm.notify(id2, notification);
    }

    @Implementation
    protected void stopForeground(boolean removeNotification) {
        this.foregroundStopped = true;
        this.notificationShouldRemoved = removeNotification;
        if (removeNotification) {
            this.removeForegroundNotification();
        }
    }

    private void removeForegroundNotification() {
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.application.getSystemService("notification");
        nm.cancel(this.lastForegroundNotificationId);
        this.lastForegroundNotification = null;
    }

    public int getLastForegroundNotificationId() {
        return this.lastForegroundNotificationId;
    }

    public Notification getLastForegroundNotification() {
        return this.lastForegroundNotification;
    }

    public boolean isStoppedBySelf() {
        return this.selfStopped;
    }

    public boolean isForegroundStopped() {
        return this.foregroundStopped;
    }

    public boolean getNotificationShouldRemoved() {
        return this.notificationShouldRemoved;
    }

    public int getStopSelfId() {
        return this.stopSelfId;
    }

    public int getStopSelfResultId() {
        return this.stopSelfResultId;
    }
}

