/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.IAccountManager;
import android.app.IAlarmManager;
import android.app.ISearchManager;
import android.app.admin.IDevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.slice.ISliceManager;
import android.app.trust.ITrustManager;
import android.app.usage.IUsageStatsManager;
import android.content.IClipboard;
import android.content.IRestrictionsManager;
import android.content.pm.IShortcutService;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.input.IInputManager;
import android.hardware.usb.IUsbManager;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.media.IAudioService;
import android.media.IMediaRouterService;
import android.media.session.ISessionManager;
import android.net.IConnectivityManager;
import android.net.INetworkScoreService;
import android.net.nsd.INsdManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.os.Binder;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPowerManager;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.view.IInputMethodManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ServiceManager.class, isInAndroidSdk=false)
public class ShadowServiceManager {
    private static final Map<String, IBinder> SERVICES;
    private static final Set<String> unavailableServices;

    @Implementation
    protected static IBinder getService(String name) {
        if (unavailableServices.contains(name)) {
            return null;
        }
        return SERVICES.get(name);
    }

    private static Binder createBinder(String className, String descriptor) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Binder binder = new Binder();
        binder.attachInterface((IInterface)ReflectionHelpers.createNullProxy(clazz), descriptor);
        return binder;
    }

    private static Binder createBinder(Class<? extends IInterface> clazz, String descriptor) {
        Binder binder = new Binder();
        binder.attachInterface((IInterface)ReflectionHelpers.createNullProxy(clazz), descriptor);
        return binder;
    }

    private static Binder createDeepBinder(Class<? extends IInterface> clazz, String descriptor) {
        Binder binder = new Binder();
        binder.attachInterface((IInterface)ReflectionHelpers.createDeepProxy(clazz), descriptor);
        return binder;
    }

    @Implementation
    protected static void addService(String name, IBinder service) {
    }

    @Implementation
    protected static IBinder checkService(String name) {
        return null;
    }

    @Implementation
    protected static String[] listServices() throws RemoteException {
        return null;
    }

    @Implementation
    protected static void initServiceCache(Map<String, IBinder> cache) {
    }

    public static void setServiceAvailability(String service, boolean available) {
        if (available) {
            unavailableServices.remove(service);
        } else {
            unavailableServices.add(service);
        }
    }

    @Resetter
    public static void reset() {
        unavailableServices.clear();
    }

    static {
        unavailableServices = new HashSet<String>();
        HashMap<String, Binder> map = new HashMap<String, Binder>();
        map.put("clipboard", ShadowServiceManager.createBinder(IClipboard.class, "android.content.IClipboard"));
        map.put("wifip2p", ShadowServiceManager.createBinder(IWifiP2pManager.class, "android.net.wifi.p2p.IWifiP2pManager"));
        map.put("account", ShadowServiceManager.createBinder(IAccountManager.class, "android.accounts.IAccountManager"));
        map.put("usb", ShadowServiceManager.createBinder(IUsbManager.class, "android.hardware.usb.IUsbManager"));
        map.put("location", ShadowServiceManager.createBinder(ILocationManager.class, "android.location.ILocationManager"));
        map.put("input_method", ShadowServiceManager.createBinder(IInputMethodManager.class, "com.android.internal.view.IInputMethodManager"));
        map.put("alarm", ShadowServiceManager.createBinder(IAlarmManager.class, "android.app.IAlarmManager"));
        map.put("power", ShadowServiceManager.createBinder(IPowerManager.class, "android.os.IPowerManager"));
        map.put("batterystats", ShadowServiceManager.createBinder(IBatteryStats.class, "com.android.internal.app.IBatteryStats"));
        map.put("dropbox", ShadowServiceManager.createBinder(IDropBoxManagerService.class, "com.android.internal.os.IDropBoxManagerService"));
        map.put("device_policy", ShadowServiceManager.createBinder(IDevicePolicyManager.class, "android.app.admin.IDevicePolicyManager"));
        map.put("connectivity", ShadowServiceManager.createBinder(IConnectivityManager.class, "android.net.IConnectivityManager"));
        map.put("wifi", ShadowServiceManager.createBinder(IWifiManager.class, "android.net.wifi.IWifiManager"));
        map.put("search", ShadowServiceManager.createBinder(ISearchManager.class, "android.app.ISearchManager"));
        map.put("uimode", ShadowServiceManager.createBinder(ISearchManager.class, "android.app.IUiModeManager"));
        map.put("netpolicy", ShadowServiceManager.createBinder(ISearchManager.class, "android.net.INetworkPolicyManager"));
        map.put("input", ShadowServiceManager.createBinder(IInputManager.class, "android.net.IInputManager"));
        map.put("country_detector", ShadowServiceManager.createBinder(ICountryDetector.class, "android.location.ICountryDetector"));
        map.put("servicediscovery", ShadowServiceManager.createBinder(INsdManager.class, "android.net.nsd.INsdManagerandroi"));
        map.put("audio", ShadowServiceManager.createBinder(IAudioService.class, "android.media.IAudioService"));
        if (RuntimeEnvironment.getApiLevel() >= 17) {
            map.put("user", ShadowServiceManager.createBinder(IUserManager.class, "android.os.IUserManager"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            map.put("appops", ShadowServiceManager.createBinder(IAppOpsService.class, "com.android.internal.app.IAppOpsService"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            map.put("batteryproperties", ShadowServiceManager.createBinder(IBatteryPropertiesRegistrar.class, "android.os.IBatteryPropertiesRegistrar"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            map.put("restrictions", ShadowServiceManager.createBinder(IRestrictionsManager.class, "android.content.IRestrictionsManager"));
            map.put("trust", ShadowServiceManager.createBinder(ITrustManager.class, "android.app.trust.ITrustManager"));
            map.put("jobscheduler", ShadowServiceManager.createBinder(IJobScheduler.class, "android.app.job.IJobScheduler"));
            map.put("network_score", ShadowServiceManager.createBinder(INetworkScoreService.class, "android.net.INetworkScoreService"));
            map.put("usagestats", ShadowServiceManager.createBinder(IUsageStatsManager.class, "android.app.usage.IUsageStatsManager"));
            map.put("media_router", ShadowServiceManager.createBinder(IMediaRouterService.class, "android.media.IMediaRouterService"));
            map.put("media_session", ShadowServiceManager.createDeepBinder(ISessionManager.class, "android.media.session.ISessionManager"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            map.put("fingerprint", ShadowServiceManager.createBinder(IFingerprintService.class, "android.hardware.fingerprint.IFingerprintService"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            map.put("shortcut", ShadowServiceManager.createBinder(IShortcutService.class, "android.content.pm.IShortcutService"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            map.put("mount", ShadowServiceManager.createBinder(IStorageManager.class, "android.os.storage.IStorageManager"));
        } else {
            map.put("mount", ShadowServiceManager.createBinder("android.os.storage.IMountService", "android.os.storage.IMountService"));
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            map.put("slice", ShadowServiceManager.createBinder(ISliceManager.class, "android.app.slice.SliceManager"));
        }
        SERVICES = Collections.unmodifiableMap(map);
    }
}

