/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;

@Implements(value=SharedMemory.class, minSdk=27, isInAndroidSdk=false)
public class ShadowSharedMemory {
    private static final Map<FileDescriptor, File> filesByFd = Collections.synchronizedMap(new WeakHashMap());
    @RealObject
    private SharedMemory realObject;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Implementation
    protected ByteBuffer map(int prot, int offset, int length) throws ErrnoException {
        ReflectionHelpers.callInstanceMethod((Object)this.realObject, (String)"checkOpen", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        File file = filesByFd.get(this.getRealFileDescriptor());
        if (file == null) {
            throw new IllegalStateException("SharedMemory from a parcel isn't yet implemented!");
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, length);
            return mappedByteBuffer;
        }
        catch (IOException e) {
            throw new ErrnoException(e.getMessage(), OsConstants.EIO, (Throwable)e);
        }
    }

    @Implementation
    protected static void unmap(ByteBuffer mappedBuf) throws ErrnoException {
        if (!(mappedBuf instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("ByteBuffer wasn't created by #map(int, int, int); can't unmap");
        }
    }

    @Implementation
    protected static FileDescriptor nCreate(String name, int size) throws ErrnoException {
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        try {
            File sharedMemoryFile = Files.createTempFile(tempDirectory.createIfNotExists("SharedMemory"), "shmem-" + name, ".tmp", new FileAttribute[0]).toFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(sharedMemoryFile, "rw");
            randomAccessFile.setLength(0L);
            randomAccessFile.setLength(size);
            filesByFd.put(randomAccessFile.getFD(), sharedMemoryFile);
            return randomAccessFile.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file descriptior", e);
        }
    }

    @Implementation
    protected static int nGetSize(FileDescriptor fd) {
        return (int)filesByFd.get(fd).length();
    }

    private FileDescriptor getRealFileDescriptor() {
        return (FileDescriptor)ReflectionHelpers.getField((Object)this.realObject, (String)"mFileDescriptor");
    }
}

