/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.slice.SliceManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=SliceManager.class, minSdk=28)
public class ShadowSliceManager {
    private static final Map<Integer, Collection<Uri>> packageUidsToPermissionGrantedSliceUris = new HashMap<Integer, Collection<Uri>>();
    private Context context;

    @Implementation
    protected void __constructor__(Context context, Handler handler) {
        this.context = context;
    }

    @Implementation
    protected synchronized void grantSlicePermission(String toPackage, Uri uri) {
        int packageUid = this.getUidForPackage(toPackage);
        Collection<Uri> uris = packageUidsToPermissionGrantedSliceUris.get(packageUid);
        if (uris == null) {
            uris = new ArrayList<Uri>();
            packageUidsToPermissionGrantedSliceUris.put(packageUid, uris);
        }
        uris.add(uri);
    }

    @Implementation
    protected synchronized void revokeSlicePermission(String toPackage, Uri uri) {
        int packageUid = this.getUidForPackage(toPackage);
        Collection<Uri> uris = packageUidsToPermissionGrantedSliceUris.get(packageUid);
        if (uris != null) {
            uris.remove(uri);
            if (uris.isEmpty()) {
                packageUidsToPermissionGrantedSliceUris.remove(packageUid);
            }
        }
    }

    @Implementation
    protected synchronized int checkSlicePermission(Uri uri, int pid, int uid) {
        if (uid == 0) {
            return 0;
        }
        Collection<Uri> uris = packageUidsToPermissionGrantedSliceUris.get(uid);
        if (uris != null && uris.contains(uri)) {
            return 0;
        }
        return -1;
    }

    private int getUidForPackage(String packageName) {
        PackageManager packageManager = this.context.getPackageManager();
        try {
            return packageManager.getPackageUid(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Resetter
    public static synchronized void reset() {
        packageUidsToPermissionGrantedSliceUris.clear();
    }
}

