/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowDrawable;

@Implements(value=StateListDrawable.class)
public class ShadowStateListDrawable
extends ShadowDrawable {
    private final Map<Integer, Integer> stateToResource = new HashMap<Integer, Integer>();
    private final Map<List<Integer>, Drawable> stateToDrawable = new HashMap<List<Integer>, Drawable>();

    public void addState(int stateId, int resId) {
        this.stateToResource.put(stateId, resId);
    }

    public int getResourceIdForState(int stateId) {
        return this.stateToResource.get(stateId);
    }

    @Implementation
    protected void addState(int[] stateSet, Drawable drawable2) {
        this.stateToDrawable.put(this.createStateList(stateSet), drawable2);
    }

    public Drawable getDrawableForState(int[] stateSet) {
        return this.stateToDrawable.get(this.createStateList(stateSet));
    }

    private List<Integer> createStateList(int[] stateSet) {
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (stateSet == StateSet.WILD_CARD) {
            stateList.add(-1);
        } else {
            for (int state : stateSet) {
                stateList.add(state);
            }
        }
        return stateList;
    }
}

