/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SubscriptionManager.class, minSdk=22)
public class ShadowSubscriptionManager {
    private static int defaultSubscriptionId = -1;
    private static int defaultDataSubscriptionId = -1;
    private static int defaultSmsSubscriptionId = -1;
    private static int defaultVoiceSubscriptionId = -1;
    private List<SubscriptionInfo> subscriptionList = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionManager.OnSubscriptionsChangedListener> listeners = new ArrayList<SubscriptionManager.OnSubscriptionsChangedListener>();
    private Set<Integer> roamingSimSubscriptionIds = new HashSet<Integer>();

    @Implementation(minSdk=24)
    protected static int getDefaultSubscriptionId() {
        return defaultSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultDataSubscriptionId() {
        return defaultDataSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultSmsSubscriptionId() {
        return defaultSmsSubscriptionId;
    }

    @Implementation(minSdk=24)
    protected static int getDefaultVoiceSubscriptionId() {
        return defaultVoiceSubscriptionId;
    }

    public static void setDefaultSubscriptionId(int defaultSubscriptionId) {
        ShadowSubscriptionManager.defaultSubscriptionId = defaultSubscriptionId;
    }

    public static void setDefaultDataSubscriptionId(int defaultDataSubscriptionId) {
        ShadowSubscriptionManager.defaultDataSubscriptionId = defaultDataSubscriptionId;
    }

    public static void setDefaultSmsSubscriptionId(int defaultSmsSubscriptionId) {
        ShadowSubscriptionManager.defaultSmsSubscriptionId = defaultSmsSubscriptionId;
    }

    public static void setDefaultVoiceSubscriptionId(int defaultVoiceSubscriptionId) {
        ShadowSubscriptionManager.defaultVoiceSubscriptionId = defaultVoiceSubscriptionId;
    }

    @Implementation(minSdk=22)
    protected List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        return this.subscriptionList;
    }

    @Implementation(minSdk=22)
    protected int getActiveSubscriptionInfoCount() {
        return this.subscriptionList == null ? 0 : this.subscriptionList.size();
    }

    @Implementation(minSdk=22)
    protected SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        if (this.subscriptionList == null) {
            return null;
        }
        for (SubscriptionInfo info : this.subscriptionList) {
            if (info.getSubscriptionId() != subId) continue;
            return info;
        }
        return null;
    }

    @Implementation(minSdk=24)
    protected SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        if (this.subscriptionList == null) {
            return null;
        }
        for (SubscriptionInfo info : this.subscriptionList) {
            if (info.getSimSlotIndex() != slotIndex) continue;
            return info;
        }
        return null;
    }

    public void setActiveSubscriptionInfoList(List<SubscriptionInfo> list) {
        this.subscriptionList = list;
        this.dispatchOnSubscriptionsChanged();
    }

    public void setActiveSubscriptionInfos(SubscriptionInfo ... infos) {
        if (infos == null) {
            this.setActiveSubscriptionInfoList(Collections.emptyList());
        } else {
            this.setActiveSubscriptionInfoList(Arrays.asList(infos));
        }
    }

    @Implementation(minSdk=22)
    protected void addOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        this.listeners.add(listener);
    }

    @Implementation(minSdk=22)
    protected void removeOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Implementation(minSdk=22)
    @HiddenApi
    protected int[] getActiveSubscriptionIdList() {
        List<SubscriptionInfo> infos = this.getActiveSubscriptionInfoList();
        if (infos == null) {
            return new int[0];
        }
        int[] ids = new int[infos.size()];
        for (int i = 0; i < infos.size(); ++i) {
            ids[i] = infos.get(i).getSubscriptionId();
        }
        return ids;
    }

    private void dispatchOnSubscriptionsChanged() {
        for (SubscriptionManager.OnSubscriptionsChangedListener listener : this.listeners) {
            listener.onSubscriptionsChanged();
        }
    }

    public void clearNetworkRoamingStatus() {
        this.roamingSimSubscriptionIds.clear();
    }

    public void setNetworkRoamingStatus(int simSubscriptionId, boolean isNetworkRoaming) {
        if (isNetworkRoaming) {
            this.roamingSimSubscriptionIds.add(simSubscriptionId);
        } else {
            this.roamingSimSubscriptionIds.remove(simSubscriptionId);
        }
    }

    @Implementation(minSdk=22)
    protected boolean isNetworkRoaming(int simSubscriptionId) {
        return this.roamingSimSubscriptionIds.contains(simSubscriptionId);
    }

    @Resetter
    public static void reset() {
        defaultDataSubscriptionId = -1;
        defaultSmsSubscriptionId = -1;
        defaultVoiceSubscriptionId = -1;
        defaultSubscriptionId = -1;
    }

    public static class SubscriptionInfoBuilder {
        private final SubscriptionInfo subscriptionInfo = (SubscriptionInfo)ReflectionHelpers.callConstructor(SubscriptionInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);

        public static SubscriptionInfoBuilder newBuilder() {
            return new SubscriptionInfoBuilder();
        }

        public SubscriptionInfo buildSubscriptionInfo() {
            return this.subscriptionInfo;
        }

        public SubscriptionInfoBuilder setId(int id2) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mId", (Object)id2);
            return this;
        }

        public SubscriptionInfoBuilder setIccId(String iccId) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIccId", (Object)iccId);
            return this;
        }

        public SubscriptionInfoBuilder setSimSlotIndex(int index) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mSimSlotIndex", (Object)index);
            return this;
        }

        public SubscriptionInfoBuilder setDisplayName(String name) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mDisplayName", (Object)name);
            return this;
        }

        public SubscriptionInfoBuilder setCarrierName(String carrierName) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mCarrierName", (Object)carrierName);
            return this;
        }

        public SubscriptionInfoBuilder setIconTint(int iconTint) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mIconTint", (Object)iconTint);
            return this;
        }

        public SubscriptionInfoBuilder setNumber(String number) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mNumber", (Object)number);
            return this;
        }

        public SubscriptionInfoBuilder setDataRoaming(int dataRoaming) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mDataRoaming", (Object)dataRoaming);
            return this;
        }

        public SubscriptionInfoBuilder setCountryIso(String countryIso) {
            ReflectionHelpers.setField((Object)this.subscriptionInfo, (String)"mCountryIso", (Object)countryIso);
            return this;
        }

        private SubscriptionInfoBuilder() {
        }
    }
}

