/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothManager;
import android.bluetooth.IBluetoothGatt;
import android.content.Context;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ShadowBluetoothManager_BleDevice;
import org.robolectric.shadows.ShadowBluetoothGattServer;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BluetoothManager.class)
public class ShadowBluetoothManager {
    private static final ImmutableIntArray VALID_STATES = ImmutableIntArray.of((int)2, (int)1, (int)0, (int)3);
    private final ArrayList<BleDevice> bleDevices = new ArrayList();

    @Implementation
    protected BluetoothAdapter getAdapter() {
        return BluetoothAdapter.getDefaultAdapter();
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int profile, int[] states) {
        Preconditions.checkArgument((boolean)this.isProfileValid(profile), (String)"Profile not supported: %s", (int)profile);
        if (states == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableIntArray stateArray = ImmutableIntArray.copyOf((int[])states);
        for (BleDevice ble : this.bleDevices) {
            if (ble.profile() != profile || !stateArray.contains(ble.state())) continue;
            result.add((Object)ble.device());
        }
        return result.build();
    }

    public void addDevice(int profile, int state, BluetoothDevice device) {
        if (this.isProfileValid(profile) && VALID_STATES.contains(state)) {
            this.bleDevices.add(BleDevice.builder().setProfile(profile).setState(state).setDevice(device).build());
        }
    }

    private boolean isProfileValid(int profile) {
        return profile == 7 || profile == 8;
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, int transport) {
        return this.createGattServer(context, callback, transport);
    }

    @Implementation(minSdk=31)
    protected BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, int transport, boolean eattSupport) {
        return this.createGattServer(context, callback, transport);
    }

    private BluetoothGattServer createGattServer(Context unusedContext, BluetoothGattServerCallback callback, int transport) {
        IBluetoothGatt iGatt = (IBluetoothGatt)ReflectionHelpers.createNullProxy(IBluetoothGatt.class);
        BluetoothGattServer gattServer = RuntimeEnvironment.getApiLevel() <= 30 ? (BluetoothGattServer)ReflectionHelpers.callConstructor(BluetoothGattServer.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IBluetoothGatt.class, (Object)iGatt), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)transport)}) : (BluetoothGattServer)ReflectionHelpers.callConstructor(BluetoothGattServer.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IBluetoothGatt.class, (Object)iGatt), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)transport), ReflectionHelpers.ClassParameter.from(BluetoothAdapter.class, (Object)this.getAdapter())});
        PerfStatsCollector.getInstance().incrementCount("constructShadowBluetoothGattServer");
        ShadowBluetoothGattServer shadowBluetoothGattServer = (ShadowBluetoothGattServer)Shadow.extract((Object)gattServer);
        shadowBluetoothGattServer.setGattServerCallback(callback);
        return gattServer;
    }

    @AutoValue
    static abstract class BleDevice {
        BleDevice() {
        }

        abstract int profile();

        abstract int state();

        abstract BluetoothDevice device();

        static Builder builder() {
            return new AutoValue_ShadowBluetoothManager_BleDevice.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setProfile(int var1);

            abstract Builder setState(int var1);

            abstract Builder setDevice(BluetoothDevice var1);

            abstract BleDevice build();
        }
    }
}

