/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import java.io.FileDescriptor;
import java.nio.Buffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.HardwareRendererNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowHardwareRenderer;
import org.robolectric.util.reflector.ForType;

@Implements(value=HardwareRenderer.class, minSdk=29, looseSignatures=true, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeHardwareRenderer {
    @Implementation(maxSdk=34)
    protected static void disableVsync() {
        HardwareRendererNatives.disableVsync();
    }

    @Implementation(maxSdk=34)
    protected static void preload() {
        HardwareRendererNatives.preload();
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static boolean isWebViewOverlaysEnabled() {
        return HardwareRendererNatives.isWebViewOverlaysEnabled();
    }

    @Implementation(maxSdk=34)
    protected static void setupShadersDiskCache(String cacheFile, String skiaCacheFile) {
        HardwareRendererNatives.setupShadersDiskCache((String)cacheFile, (String)skiaCacheFile);
    }

    @Implementation(maxSdk=34)
    protected static void nRotateProcessStatsBuffer() {
        HardwareRendererNatives.nRotateProcessStatsBuffer();
    }

    @Implementation(maxSdk=34)
    protected static void nSetProcessStatsBuffer(int fd) {
        HardwareRendererNatives.nSetProcessStatsBuffer((int)fd);
    }

    @Implementation(maxSdk=34)
    protected static int nGetRenderThreadTid(long nativeProxy) {
        return HardwareRendererNatives.nGetRenderThreadTid((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static long nCreateRootRenderNode() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return HardwareRendererNatives.nCreateRootRenderNode();
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nCreateProxy(boolean translucent, long rootRenderNode) {
        return HardwareRendererNatives.nCreateProxy((boolean)translucent, (long)rootRenderNode);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected static long nCreateProxy(boolean translucent, boolean isWideGamut, long rootRenderNode) {
        return ShadowNativeHardwareRenderer.nCreateProxy(true, rootRenderNode);
    }

    @Implementation(minSdk=29, maxSdk=29)
    protected static Object nCreateProxy(Object translucent, Object rootRenderNode) {
        return ShadowNativeHardwareRenderer.nCreateProxy((Boolean)translucent, (Long)rootRenderNode);
    }

    @Implementation(maxSdk=34)
    protected static void nDeleteProxy(long nativeProxy) {
        HardwareRendererNatives.nDeleteProxy((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static boolean nLoadSystemProperties(long nativeProxy) {
        return HardwareRendererNatives.nLoadSystemProperties((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nSetName(long nativeProxy, String name) {
        HardwareRendererNatives.nSetName((long)nativeProxy, (String)name);
    }

    @Implementation(minSdk=29, maxSdk=29)
    protected static void nSetSurface(long nativeProxy, Surface window) {
        HardwareRendererNatives.nSetSurface((long)nativeProxy, (Surface)window, (boolean)false);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static void nSetSurface(long nativeProxy, Surface window, boolean discardBuffer) {
        HardwareRendererNatives.nSetSurface((long)nativeProxy, (Surface)window, (boolean)discardBuffer);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetSurfaceControl(long nativeProxy, long nativeSurfaceControl) {
        HardwareRendererNatives.nSetSurfaceControl((long)nativeProxy, (long)nativeSurfaceControl);
    }

    @Implementation(maxSdk=34)
    protected static boolean nPause(long nativeProxy) {
        return HardwareRendererNatives.nPause((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nSetStopped(long nativeProxy, boolean stopped) {
        HardwareRendererNatives.nSetStopped((long)nativeProxy, (boolean)stopped);
    }

    @Implementation(maxSdk=34)
    protected static void nSetLightGeometry(long nativeProxy, float lightX, float lightY, float lightZ, float lightRadius) {
        HardwareRendererNatives.nSetLightGeometry((long)nativeProxy, (float)lightX, (float)lightY, (float)lightZ, (float)lightRadius);
    }

    @Implementation(maxSdk=34)
    protected static void nSetLightAlpha(long nativeProxy, float ambientShadowAlpha, float spotShadowAlpha) {
        HardwareRendererNatives.nSetLightAlpha((long)nativeProxy, (float)ambientShadowAlpha, (float)spotShadowAlpha);
    }

    @Implementation(maxSdk=34)
    protected static void nSetOpaque(long nativeProxy, boolean opaque) {
        HardwareRendererNatives.nSetOpaque((long)nativeProxy, (boolean)opaque);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static Object nSetColorMode(long nativeProxy, int colorMode) {
        HardwareRendererNatives.nSetColorMode((long)nativeProxy, (int)colorMode);
        return null;
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetSdrWhitePoint(long nativeProxy, float whitePoint) {
        HardwareRendererNatives.nSetSdrWhitePoint((long)nativeProxy, (float)whitePoint);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetIsHighEndGfx(boolean isHighEndGfx) {
        HardwareRendererNatives.nSetIsHighEndGfx((boolean)isHighEndGfx);
    }

    @Implementation(maxSdk=34)
    protected static int nSyncAndDrawFrame(long nativeProxy, long[] frameInfo, int size) {
        return HardwareRendererNatives.nSyncAndDrawFrame((long)nativeProxy, (long[])frameInfo, (int)size);
    }

    @Implementation(maxSdk=34)
    protected static void nDestroy(long nativeProxy, long rootRenderNode) {
        HardwareRendererNatives.nDestroy((long)nativeProxy, (long)rootRenderNode);
    }

    @Implementation(maxSdk=34)
    protected static void nRegisterAnimatingRenderNode(long rootRenderNode, long animatingNode) {
        HardwareRendererNatives.nRegisterAnimatingRenderNode((long)rootRenderNode, (long)animatingNode);
    }

    @Implementation(maxSdk=34)
    protected static void nRegisterVectorDrawableAnimator(long rootRenderNode, long animator) {
        HardwareRendererNatives.nRegisterVectorDrawableAnimator((long)rootRenderNode, (long)animator);
    }

    @Implementation(maxSdk=34)
    protected static long nCreateTextureLayer(long nativeProxy) {
        return HardwareRendererNatives.nCreateTextureLayer((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nBuildLayer(long nativeProxy, long node) {
        HardwareRendererNatives.nBuildLayer((long)nativeProxy, (long)node);
    }

    @Implementation(maxSdk=34)
    protected static boolean nCopyLayerInto(long nativeProxy, long layer, long bitmapHandle) {
        return HardwareRendererNatives.nCopyLayerInto((long)nativeProxy, (long)layer, (long)bitmapHandle);
    }

    @Implementation(maxSdk=34)
    protected static void nPushLayerUpdate(long nativeProxy, long layer) {
        HardwareRendererNatives.nPushLayerUpdate((long)nativeProxy, (long)layer);
    }

    @Implementation(maxSdk=34)
    protected static void nCancelLayerUpdate(long nativeProxy, long layer) {
        HardwareRendererNatives.nCancelLayerUpdate((long)nativeProxy, (long)layer);
    }

    @Implementation(maxSdk=34)
    protected static void nDetachSurfaceTexture(long nativeProxy, long layer) {
        HardwareRendererNatives.nDetachSurfaceTexture((long)nativeProxy, (long)layer);
    }

    @Implementation(maxSdk=34)
    protected static void nDestroyHardwareResources(long nativeProxy) {
        HardwareRendererNatives.nDestroyHardwareResources((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nTrimMemory(int level) {
        HardwareRendererNatives.nTrimMemory((int)level);
    }

    @Implementation(maxSdk=34)
    protected static void nOverrideProperty(String name, String value) {
        HardwareRendererNatives.nOverrideProperty((String)name, (String)value);
    }

    @Implementation(maxSdk=34)
    protected static void nFence(long nativeProxy) {
        HardwareRendererNatives.nFence((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nStopDrawing(long nativeProxy) {
        HardwareRendererNatives.nStopDrawing((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nNotifyFramePending(long nativeProxy) {
        HardwareRendererNatives.nNotifyFramePending((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nDumpProfileInfo(long nativeProxy, FileDescriptor fd, int dumpFlags) {
        HardwareRendererNatives.nDumpProfileInfo((long)nativeProxy, (FileDescriptor)fd, (int)dumpFlags);
    }

    @Implementation(maxSdk=34)
    protected static void nAddRenderNode(long nativeProxy, long rootRenderNode, boolean placeFront) {
        HardwareRendererNatives.nAddRenderNode((long)nativeProxy, (long)rootRenderNode, (boolean)placeFront);
    }

    @Implementation(maxSdk=34)
    protected static void nRemoveRenderNode(long nativeProxy, long rootRenderNode) {
        HardwareRendererNatives.nRemoveRenderNode((long)nativeProxy, (long)rootRenderNode);
    }

    @Implementation(maxSdk=34)
    protected static void nDrawRenderNode(long nativeProxy, long rootRenderNode) {
        HardwareRendererNatives.nDrawRenderNode((long)nativeProxy, (long)rootRenderNode);
    }

    @Implementation(maxSdk=34)
    protected static void nSetContentDrawBounds(long nativeProxy, int left, int top, int right, int bottom) {
        HardwareRendererNatives.nSetContentDrawBounds((long)nativeProxy, (int)left, (int)top, (int)right, (int)bottom);
    }

    @Implementation(maxSdk=34)
    protected static void nSetPictureCaptureCallback(long nativeProxy, HardwareRenderer.PictureCapturedCallback callback) {
        HardwareRendererNatives.nSetPictureCaptureCallback((long)nativeProxy, (HardwareRenderer.PictureCapturedCallback)callback);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetASurfaceTransactionCallback(Object nativeProxy, Object callback) {
        HardwareRendererNatives.nSetASurfaceTransactionCallback((long)((Long)nativeProxy), (HardwareRenderer.ASurfaceTransactionCallback)((HardwareRenderer.ASurfaceTransactionCallback)callback));
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetPrepareSurfaceControlForWebviewCallback(Object nativeProxy, Object callback) {
        HardwareRendererNatives.nSetPrepareSurfaceControlForWebviewCallback((long)((Long)nativeProxy), (HardwareRenderer.PrepareSurfaceControlForWebviewCallback)((HardwareRenderer.PrepareSurfaceControlForWebviewCallback)callback));
    }

    @Implementation(maxSdk=34)
    protected static void nSetFrameCallback(long nativeProxy, HardwareRenderer.FrameDrawingCallback callback) {
        HardwareRendererNatives.nSetFrameCallback((long)nativeProxy, (HardwareRenderer.FrameDrawingCallback)callback);
    }

    @Implementation(maxSdk=34)
    protected static void nSetFrameCompleteCallback(long nativeProxy, HardwareRenderer.FrameCompleteCallback callback) {
        HardwareRendererNatives.nSetFrameCompleteCallback((long)nativeProxy, (HardwareRenderer.FrameCompleteCallback)callback);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static void nAddObserver(long nativeProxy, long nativeObserver) {
        HardwareRendererNatives.nAddObserver((long)nativeProxy, (long)nativeObserver);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static void nRemoveObserver(long nativeProxy, long nativeObserver) {
        HardwareRendererNatives.nRemoveObserver((long)nativeProxy, (long)nativeObserver);
    }

    @Implementation(maxSdk=33)
    protected static int nCopySurfaceInto(Surface surface, int srcLeft, int srcTop, int srcRight, int srcBottom, long bitmapHandle) {
        return HardwareRendererNatives.nCopySurfaceInto((Surface)surface, (int)srcLeft, (int)srcTop, (int)srcRight, (int)srcBottom, (long)bitmapHandle);
    }

    @Implementation(maxSdk=30)
    protected static Bitmap nCreateHardwareBitmap(long renderNode, int width, int height) {
        return HardwareRendererNatives.nCreateHardwareBitmap((long)renderNode, (int)width, (int)height);
    }

    @Implementation(maxSdk=34)
    protected static void nSetHighContrastText(boolean enabled) {
        HardwareRendererNatives.nSetHighContrastText((boolean)enabled);
    }

    @Implementation(minSdk=29, maxSdk=32)
    protected static void nHackySetRTAnimationsEnabled(boolean enabled) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        HardwareRendererNatives.nHackySetRTAnimationsEnabled((boolean)enabled);
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected static void nSetRtAnimationsEnabled(boolean enabled) {
        ShadowNativeHardwareRenderer.nHackySetRTAnimationsEnabled(enabled);
    }

    @Implementation(maxSdk=34)
    protected static void nSetDebuggingEnabled(boolean enabled) {
        HardwareRendererNatives.nSetDebuggingEnabled((boolean)enabled);
    }

    @Implementation(maxSdk=34)
    protected static void nSetIsolatedProcess(boolean enabled) {
        HardwareRendererNatives.nSetIsolatedProcess((boolean)enabled);
    }

    @Implementation(maxSdk=34)
    protected static void nSetContextPriority(int priority) {
        HardwareRendererNatives.nSetContextPriority((int)priority);
    }

    @Implementation(maxSdk=34)
    protected static void nAllocateBuffers(long nativeProxy) {
        HardwareRendererNatives.nAllocateBuffers((long)nativeProxy);
    }

    @Implementation(maxSdk=34)
    protected static void nSetForceDark(long nativeProxy, boolean enabled) {
        HardwareRendererNatives.nSetForceDark((long)nativeProxy, (boolean)enabled);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nSetDisplayDensityDpi(int densityDpi) {
        HardwareRendererNatives.nSetDisplayDensityDpi((int)densityDpi);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static void nInitDisplayInfo(int width, int height, float refreshRate, int wideColorDataspace, long appVsyncOffsetNanos, long presentationDeadlineNanos) {
        HardwareRendererNatives.nInitDisplayInfo((int)width, (int)height, (float)refreshRate, (int)wideColorDataspace, (long)appVsyncOffsetNanos, (long)presentationDeadlineNanos);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static void nInitDisplayInfo(int width, int height, float refreshRate, int wideColorDataspace, long appVsyncOffsetNanos, long presentationDeadlineNanos, boolean supportsFp16ForHdr, boolean nInitDisplayInfo) {
        ShadowNativeHardwareRenderer.nInitDisplayInfo(width, height, refreshRate, wideColorDataspace, appVsyncOffsetNanos, presentationDeadlineNanos);
    }

    @Implementation(minSdk=29)
    protected static Bitmap createHardwareBitmap(RenderNode node, int width, int height) {
        try (ImageReader imageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)1);){
            HardwareRenderer renderer = new HardwareRenderer();
            Surface surface = imageReader.getSurface();
            renderer.setSurface(surface);
            renderer.setContentRoot(node);
            renderer.setLightSourceGeometry(0.0f, 0.0f, 0.0f, 0.0f);
            renderer.setLightSourceAlpha(0.0f, 0.0f);
            renderer.createRenderRequest().syncAndDraw();
            Image nativeImage = imageReader.acquireNextImage();
            Image.Plane[] planes = nativeImage.getPlanes();
            Bitmap destBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            destBitmap.copyPixelsFromBuffer((Buffer)planes[0].getBuffer());
            surface.release();
            Bitmap bitmap = destBitmap.copy(Bitmap.Config.HARDWARE, false);
            return bitmap;
        }
    }

    @Implementation(maxSdk=30)
    protected static void nSetWideGamut(long nativeProxy, boolean isWideColorGamut) {
        ShadowNativeHardwareRenderer.nSetColorMode(nativeProxy, isWideColorGamut ? 1 : 0);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowHardwareRenderer.class, ShadowNativeHardwareRenderer.class);
        }
    }

    @ForType(value=HardwareRenderer.class)
    static interface HardwareRendererReflector {
        public void setWideGamut(boolean var1);

        public void setSurface(Surface var1);
    }
}

