/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteConnection;
import android.os.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.annotation.SQLiteMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadows.SQLiteShadowPicker;
import org.robolectric.shadows.ShadowLegacySQLiteConnection;
import org.robolectric.shadows.ShadowNativeSQLiteConnection;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(className="android.database.sqlite.SQLiteConnection", isInAndroidSdk=false, shadowPicker=Picker.class)
public class ShadowSQLiteConnection {
    Throwable onCreate = new Throwable();
    protected static AtomicBoolean useInMemoryDatabase = new AtomicBoolean();
    private final AtomicBoolean disposed = new AtomicBoolean();
    @RealObject
    SQLiteConnection realObject;
    @ReflectorObject
    SQLiteConnectionReflector sqliteConnectionReflector;

    @Implementation
    protected void dispose(boolean finalized) {
        if (this.disposed.compareAndSet(false, true)) {
            this.sqliteConnectionReflector.dispose(finalized);
        }
    }

    public static void setUseInMemoryDatabase(boolean value) {
        if (ShadowSQLiteConnection.sqliteMode() != SQLiteMode.Mode.LEGACY) {
            throw new UnsupportedOperationException("this action is not supported in " + ShadowSQLiteConnection.sqliteMode() + " mode.");
        }
        useInMemoryDatabase.set(value);
    }

    public static SQLiteMode.Mode sqliteMode() {
        return (SQLiteMode.Mode)ConfigurationRegistry.get(SQLiteMode.Mode.class);
    }

    public static void setDefaultSyncMode(String value) {
        SystemProperties.set((String)"debug.sqlite.syncmode", (String)value);
        SystemProperties.set((String)"debug.sqlite.wal.syncmode", (String)value);
    }

    public static void setDefaultJournalMode(String value) {
        SystemProperties.set((String)"debug.sqlite.journalmode", (String)value);
    }

    @Resetter
    public static void reset() {
        useInMemoryDatabase.set(false);
    }

    @ForType(value=SQLiteConnection.class)
    static interface SQLiteConnectionReflector {
        @Direct
        public void dispose(boolean var1);
    }

    public static class Picker
    extends SQLiteShadowPicker<ShadowSQLiteConnection> {
        public Picker() {
            super(ShadowLegacySQLiteConnection.class, ShadowNativeSQLiteConnection.class);
        }
    }
}

