/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemVibrator;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowVibrator;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SystemVibrator.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowSystemVibrator
extends ShadowVibrator {
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable stopVibratingRunnable = () -> {
        vibrating = false;
    };

    @Implementation
    protected boolean hasVibrator() {
        return hasVibrator;
    }

    @Implementation(minSdk=26)
    protected boolean hasAmplitudeControl() {
        return hasAmplitudeControl;
    }

    @Implementation(maxSdk=25)
    protected void vibrate(int uid, String opPkg, long[] pattern, int repeat, AudioAttributes attributes) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(maxSdk=25)
    protected void vibrate(int uid, String opPkg, long milliseconds, AudioAttributes attributes) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, AudioAttributes attributes) {
        this.vibrate(uid, opPkg, effect, null, attributes);
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, AudioAttributes attributes) {
        try {
            Class<?> waveformClass = Class.forName("android.os.VibrationEffect$Waveform");
            Class<?> prebakedClass = Class.forName("android.os.VibrationEffect$Prebaked");
            Class<?> oneShotClass = Class.forName("android.os.VibrationEffect$OneShot");
            Optional<Object> composedClass = Optional.empty();
            if (RuntimeEnvironment.getApiLevel() == 30) {
                composedClass = Optional.of(Class.forName("android.os.VibrationEffect$Composed"));
            }
            if (waveformClass.isInstance(effect)) {
                this.recordVibratePattern((long[])ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getTimings", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), (int)((Integer)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getRepeatIndex", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])));
            } else if (prebakedClass.isInstance(effect)) {
                this.recordVibratePredefined((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getDuration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), (Integer)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
            } else if (oneShotClass.isInstance(effect)) {
                long timing = RuntimeEnvironment.getApiLevel() >= 28 ? ((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getDuration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])).longValue() : ((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getTiming", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])).longValue();
                this.recordVibrate(timing);
            } else if (composedClass.isPresent() && ((Class)composedClass.get()).isInstance(effect)) {
                VibrationEffect.Composed composed = (VibrationEffect.Composed)effect;
                List effects = (List)ReflectionHelpers.callInstanceMethod((Object)composed, (String)"getPrimitiveEffects", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                primitiveEffects.clear();
                for (Object primitiveEffect : effects) {
                    primitiveEffects.add(new ShadowVibrator.PrimitiveEffect((Integer)ReflectionHelpers.getField(primitiveEffect, (String)"id"), ((Float)ReflectionHelpers.getField(primitiveEffect, (String)"scale")).floatValue(), (Integer)ReflectionHelpers.getField(primitiveEffect, (String)"delay")));
                }
            } else {
                throw new UnsupportedOperationException("unrecognized effect type " + effect.getClass().getName());
            }
            audioAttributesFromLastVibration = attributes;
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("unrecognized effect type " + effect.getClass().getName(), e);
        }
    }

    @Implementation(minSdk=31)
    protected void vibrate(Object uid, Object opPkg, Object effect, Object reason, Object attributes) {
        Preconditions.checkArgument((boolean)(uid instanceof Integer));
        Preconditions.checkArgument((opPkg == null || opPkg instanceof String ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(effect instanceof VibrationEffect));
        Preconditions.checkArgument((reason == null || reason instanceof String ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(attributes instanceof VibrationAttributes));
        if (!(effect instanceof VibrationEffect.Composed)) {
            throw new UnsupportedOperationException("unrecognized effect type " + effect.getClass().getName());
        }
        VibrationEffect.Composed composedEffect = (VibrationEffect.Composed)effect;
        vibrationAttributesFromLastVibration = attributes;
        this.recordVibratePattern(composedEffect.getSegments(), composedEffect.getRepeatIndex());
    }

    private void recordVibratePattern(List<VibrationEffectSegment> segments, int repeatIndex) {
        long[] pattern = new long[segments.size()];
        int i = 0;
        for (VibrationEffectSegment segment : segments) {
            pattern[i] = segment.getDuration();
            ++i;
        }
        vibrationEffectSegments.clear();
        vibrationEffectSegments.addAll(segments);
        this.recordVibratePattern(pattern, repeatIndex);
    }

    private void recordVibratePredefined(long milliseconds, int effectId) {
        vibrating = true;
        ShadowVibrator.effectId = effectId;
        ShadowVibrator.milliseconds = milliseconds;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        this.handler.postDelayed(this.stopVibratingRunnable, ShadowVibrator.milliseconds);
    }

    private void recordVibrate(long milliseconds) {
        vibrating = true;
        ShadowVibrator.milliseconds = milliseconds;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        this.handler.postDelayed(this.stopVibratingRunnable, ShadowVibrator.milliseconds);
    }

    protected void recordVibratePattern(long[] pattern, int repeat) {
        vibrating = true;
        ShadowVibrator.pattern = pattern;
        ShadowVibrator.repeat = repeat;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        if (repeat < 0) {
            long endDelayMillis = 0L;
            for (long t : pattern) {
                endDelayMillis += t;
            }
            ShadowVibrator.milliseconds = endDelayMillis;
            this.handler.postDelayed(this.stopVibratingRunnable, endDelayMillis);
        }
    }

    @Implementation
    protected void cancel() {
        cancelled = true;
        vibrating = false;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
    }
}

