/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.io.File;

final class OsConstantsValues {
    public static final String S_IFMT = "S_IFMT";
    public static final String S_IFDIR = "S_IFDIR";
    public static final String S_IFREG = "S_IFREG";
    public static final String S_IFLNK = "S_IFLNK";
    public static final int S_IFMT_VALUE = 0x170000;
    public static final int S_IFDIR_VALUE = 262144;
    public static final int S_IFREG_VALUE = 0x100000;
    public static final int S_IFLNK_VALUE = 0x120000;

    private OsConstantsValues() {
    }

    public static int getMode(String path) {
        if (path == null) {
            return 0;
        }
        File file = new File(path);
        if (file.isDirectory()) {
            return 262144;
        }
        if (file.isFile()) {
            return 0x100000;
        }
        if (!OsConstantsValues.canonicalize(path).equals(path)) {
            return 0x120000;
        }
        return 0;
    }

    private static String canonicalize(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

