/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AppWidgetManager.class)
public class ShadowAppWidgetManager {
    @RealObject
    private AppWidgetManager realAppWidgetManager;
    private Context context;
    private final Map<Integer, WidgetInfo> widgetInfos = new HashMap<Integer, WidgetInfo>();
    private int nextWidgetId = 1;
    private boolean alwaysRecreateViewsDuringUpdate = false;
    private boolean allowedToBindWidgets;
    private boolean validWidgetProviderComponentName = true;
    private final ArrayList<AppWidgetProviderInfo> installedProviders = new ArrayList();

    @Implementation(maxSdk=19)
    protected void __constructor__(Context context) {
        this.context = context;
    }

    @Implementation(minSdk=21)
    protected void __constructor__(Context context, IAppWidgetService service) {
        this.context = context;
    }

    @Implementation
    protected void updateAppWidget(int[] appWidgetIds, RemoteViews views) {
        for (int appWidgetId : appWidgetIds) {
            this.updateAppWidget(appWidgetId, views);
        }
    }

    @Implementation
    protected void updateAppWidget(int appWidgetId, RemoteViews views) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        int layoutId = views.getLayoutId();
        if (widgetInfo.layoutId != layoutId || this.alwaysRecreateViewsDuringUpdate) {
            widgetInfo.view = this.createWidgetView(layoutId);
            widgetInfo.layoutId = layoutId;
        }
        widgetInfo.lastRemoteViews = views;
        views.reapply(this.context, widgetInfo.view);
    }

    @Implementation
    protected int[] getAppWidgetIds(ComponentName provider) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int id2 : this.widgetInfos.keySet()) {
            WidgetInfo widgetInfo = this.widgetInfos.get(id2);
            if (!provider.equals((Object)widgetInfo.providerComponent)) continue;
            idList.add(id2);
        }
        int[] ids = new int[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = (Integer)idList.get(i);
        }
        return ids;
    }

    @Implementation
    protected List<AppWidgetProviderInfo> getInstalledProviders() {
        return new ArrayList<AppWidgetProviderInfo>(this.installedProviders);
    }

    public void addInstalledProvider(AppWidgetProviderInfo appWidgetProviderInfo) {
        this.installedProviders.add(appWidgetProviderInfo);
    }

    public void addBoundWidget(int appWidgetId, AppWidgetProviderInfo providerInfo) {
        this.addInstalledProvider(providerInfo);
        this.bindAppWidgetId(appWidgetId, providerInfo.provider);
        this.widgetInfos.get((Object)Integer.valueOf((int)appWidgetId)).info = providerInfo;
    }

    @Deprecated
    public void putWidgetInfo(int appWidgetId, AppWidgetProviderInfo expectedWidgetInfo) {
        this.addBoundWidget(appWidgetId, expectedWidgetInfo);
    }

    @Implementation
    protected AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        if (widgetInfo == null) {
            return null;
        }
        return widgetInfo.info;
    }

    @HiddenApi
    @Implementation
    public void bindAppWidgetId(int appWidgetId, ComponentName provider) {
        WidgetInfo widgetInfo = new WidgetInfo(provider);
        this.widgetInfos.put(appWidgetId, widgetInfo);
        for (AppWidgetProviderInfo appWidgetProviderInfo : this.installedProviders) {
            if (provider == null || !provider.equals((Object)appWidgetProviderInfo.provider)) continue;
            widgetInfo.info = appWidgetProviderInfo;
        }
    }

    @Implementation
    protected boolean bindAppWidgetIdIfAllowed(int appWidgetId, ComponentName provider) {
        if (this.validWidgetProviderComponentName) {
            this.bindAppWidgetId(appWidgetId, provider);
            return this.allowedToBindWidgets;
        }
        throw new IllegalArgumentException("not an appwidget provider");
    }

    public void reconstructWidgetViewAsIfPhoneWasRotated(int appWidgetId) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        widgetInfo.view = this.createWidgetView(widgetInfo.layoutId);
        widgetInfo.lastRemoteViews.reapply(this.context, widgetInfo.view);
    }

    public int createWidget(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId) {
        return this.createWidgets(appWidgetProviderClass, widgetLayoutId, 1)[0];
    }

    public int[] createWidgets(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId, int howManyToCreate) {
        AppWidgetProvider appWidgetProvider = (AppWidgetProvider)ReflectionHelpers.callConstructor(appWidgetProviderClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        int[] newWidgetIds = new int[howManyToCreate];
        for (int i = 0; i < howManyToCreate; ++i) {
            int myWidgetId;
            View widgetView = this.createWidgetView(widgetLayoutId);
            ++this.nextWidgetId;
            this.widgetInfos.put(myWidgetId, new WidgetInfo(widgetView, widgetLayoutId, appWidgetProvider));
            newWidgetIds[i] = myWidgetId;
        }
        appWidgetProvider.onUpdate(this.context, this.realAppWidgetManager, newWidgetIds);
        return newWidgetIds;
    }

    private View createWidgetView(int widgetLayoutId) {
        return LayoutInflater.from((Context)RuntimeEnvironment.application).inflate(widgetLayoutId, null);
    }

    public View getViewFor(int widgetId) {
        return this.widgetInfos.get((Object)Integer.valueOf((int)widgetId)).view;
    }

    public AppWidgetProvider getAppWidgetProviderFor(int widgetId) {
        return this.widgetInfos.get((Object)Integer.valueOf((int)widgetId)).appWidgetProvider;
    }

    public void setAlwaysRecreateViewsDuringUpdate(boolean alwaysRecreate) {
        this.alwaysRecreateViewsDuringUpdate = alwaysRecreate;
    }

    public boolean getAlwaysRecreateViewsDuringUpdate() {
        return this.alwaysRecreateViewsDuringUpdate;
    }

    public void setAllowedToBindAppWidgets(boolean allowed) {
        this.allowedToBindWidgets = allowed;
    }

    public void setValidWidgetProviderComponentName(boolean validWidgetProviderComponentName) {
        this.validWidgetProviderComponentName = validWidgetProviderComponentName;
    }

    private static class WidgetInfo {
        View view;
        int layoutId;
        final AppWidgetProvider appWidgetProvider;
        RemoteViews lastRemoteViews;
        final ComponentName providerComponent;
        AppWidgetProviderInfo info;

        public WidgetInfo(View view, int layoutId, AppWidgetProvider appWidgetProvider) {
            this.view = view;
            this.layoutId = layoutId;
            this.appWidgetProvider = appWidgetProvider;
            String packageName = appWidgetProvider.getClass().getPackage().getName();
            String className = appWidgetProvider.getClass().getName();
            this.providerComponent = new ComponentName(packageName, className);
        }

        public WidgetInfo(ComponentName providerComponent) {
            this.providerComponent = providerComponent;
            this.appWidgetProvider = null;
        }
    }
}

