/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.IBluetooth;
import android.content.Context;
import android.os.Handler;
import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBluetoothGatt;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BluetoothDevice.class)
public class ShadowBluetoothDevice {
    @RealObject
    private BluetoothDevice realBluetoothDevice;
    private String name;
    private ParcelUuid[] uuids;
    private int bondState = 10;
    private boolean createdBond = false;
    private boolean fetchUuidsWithSdpResult = false;
    private int fetchUuidsWithSdpCount = 0;
    private int type = 0;
    private final List<BluetoothGatt> bluetoothGatts = new ArrayList<BluetoothGatt>();

    public static BluetoothDevice newInstance(String address) {
        return (BluetoothDevice)ReflectionHelpers.callConstructor(BluetoothDevice.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)address)});
    }

    @Implementation
    protected static IBluetooth getService() {
        try {
            return (IBluetooth)Shadow.directlyOn(BluetoothDevice.class, (String)"getService", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Implementation(minSdk=18)
    protected int getType() {
        return this.type;
    }

    public void setUuids(ParcelUuid[] uuids) {
        this.uuids = uuids;
    }

    @Implementation
    protected ParcelUuid[] getUuids() {
        return this.uuids;
    }

    public void setBondState(int bondState) {
        this.bondState = bondState;
    }

    @Implementation
    protected int getBondState() {
        return this.bondState;
    }

    public void setCreatedBond(boolean createdBond) {
        this.createdBond = createdBond;
    }

    @Implementation
    protected boolean createBond() {
        return this.createdBond;
    }

    public void setFetchUuidsWithSdpResult(boolean fetchUuidsWithSdpResult) {
        this.fetchUuidsWithSdpResult = fetchUuidsWithSdpResult;
    }

    @Implementation
    protected boolean fetchUuidsWithSdp() {
        ++this.fetchUuidsWithSdpCount;
        return this.fetchUuidsWithSdpResult;
    }

    public int getFetchUuidsWithSdpCount() {
        return this.fetchUuidsWithSdpCount;
    }

    @Implementation(minSdk=18)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=23)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=26)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        return this.connectGatt(callback);
    }

    private BluetoothGatt connectGatt(BluetoothGattCallback callback) {
        BluetoothGatt bluetoothGatt = ShadowBluetoothGatt.newInstance(this.realBluetoothDevice);
        this.bluetoothGatts.add(bluetoothGatt);
        ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
        shadowBluetoothGatt.setGattCallback(callback);
        return bluetoothGatt;
    }

    public List<BluetoothGatt> getBluetoothGatts() {
        return this.bluetoothGatts;
    }

    public void simulateGattConnectionChange(int status, int newState) {
        for (BluetoothGatt bluetoothGatt : this.bluetoothGatts) {
            ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
            BluetoothGattCallback gattCallback = shadowBluetoothGatt.getGattCallback();
            gattCallback.onConnectionStateChange(bluetoothGatt, status, newState);
        }
    }
}

