/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiSsid;
import java.net.InetAddress;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WifiInfo.class)
public class ShadowWifiInfo {
    @RealObject
    WifiInfo realObject;

    public static WifiInfo newInstance() {
        return (WifiInfo)ReflectionHelpers.callConstructor(WifiInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setInetAddress(InetAddress address) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setInetAddress(address);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setInetAddress", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(InetAddress.class, (Object)address)});
        }
    }

    public void setMacAddress(String newMacAddress) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setMacAddress(newMacAddress);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setMacAddress", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)newMacAddress)});
        }
    }

    public void setSSID(String ssid) {
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setSSID", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)ssid)});
        } else if (RuntimeEnvironment.getApiLevel() <= 19) {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setSSID", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(WifiSsid.class, (Object)ShadowWifiInfo.getWifiSsid(ssid))});
        } else {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setSSID((WifiSsid)ShadowWifiInfo.getWifiSsid(ssid));
        }
    }

    private static Object getWifiSsid(String ssid) {
        WifiSsid wifiSsid = ssid.startsWith("0x") ? WifiSsid.createFromHex((String)ssid) : WifiSsid.createFromAsciiEncoded((String)ssid);
        return wifiSsid;
    }

    public void setBSSID(String bssid) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setBSSID(bssid);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setBSSID", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)bssid)});
        }
    }

    public void setSupplicantState(SupplicantState state) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setSupplicantState(state);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setSupplicantState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(SupplicantState.class, (Object)state)});
        }
    }

    public void setRssi(int rssi) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setRssi(rssi);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setRssi", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi)});
        }
    }

    public void setLinkSpeed(int linkSpeed) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setLinkSpeed(linkSpeed);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setLinkSpeed", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)linkSpeed)});
        }
    }

    public void setFrequency(int frequency) {
        ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setFrequency(frequency);
    }

    public void setNetworkId(int id2) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ((WifiInfo)Shadow.directlyOn((Object)this.realObject, WifiInfo.class)).setNetworkId(id2);
        } else {
            Shadow.directlyOn((Object)this.realObject, WifiInfo.class, (String)"setNetworkId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2)});
        }
    }
}

