/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator$GroupedIterator$;
import scala.collection.Iterator$IteratorIteratorOps$;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Iterator<A>
extends ScalaObject {
    public <B> void readInto(B[] var1);

    public <B> void readInto(B[] var1, int var2);

    public <B> void readInto(B[] var1, int var2, int var3);

    public Object counted();

    public Seq<A> collect();

    public int findIndexOf(Function1<A, Boolean> var1);

    public <B> Object append(Iterator<B> var1);

    public String toString();

    public StringBuilder addString(StringBuilder var1);

    public StringBuilder addString(StringBuilder var1, String var2);

    public StringBuilder addString(StringBuilder var1, String var2, String var3, String var4);

    public String mkString();

    public String mkString(String var1);

    public String mkString(String var1, String var2, String var3);

    public Seq<A> toSeq();

    public Stream<A> toStream();

    public List<A> toList();

    public <B> void copyToBuffer(Buffer<B> var1);

    public <B> void copyToArray(B[] var1);

    public <B> void copyToArray(B[] var1, int var2);

    public <B> void copyToArray(B[] var1, int var2, int var3);

    public <B> Object patch(int var1, Iterator<B> var2, int var3);

    public Tuple2<Iterator<A>, Iterator<A>> duplicate();

    public int length();

    public <B> GroupedIterator<B> sliding(int var1, int var2);

    public <B> GroupedIterator<B> grouped(int var1);

    public Object buffered();

    public <B> Option<B> reduceRightOption(Function2<A, B, B> var1);

    public <B> Option<B> reduceLeftOption(Function2<B, A, B> var1);

    public <B> B reduceRight(Function2<A, B, B> var1);

    public <B> B reduceLeft(Function2<B, A, B> var1);

    public <B> B $colon$bslash(B var1, Function2<A, B, B> var2);

    public <B> B $div$colon(B var1, Function2<B, A, B> var2);

    public <B> B foldRight(B var1, Function2<A, B, B> var2);

    public <B> B foldLeft(B var1, Function2<B, A, B> var2);

    public <B> int indexOf(B var1);

    public int indexWhere(Function1<A, Boolean> var1);

    public Option<A> find(Function1<A, Boolean> var1);

    public boolean contains(Object var1);

    public boolean exists(Function1<A, Boolean> var1);

    public boolean forall(Function1<A, Boolean> var1);

    public <U> void foreach(Function1<A, U> var1);

    public <B, A1, B1> Object zipAll(Iterator<B> var1, A1 var2, B1 var3);

    public Object zipWithIndex();

    public <A1> Object padTo(int var1, A1 var2);

    public <B> Object zip(Iterator<B> var1);

    public Iterator<A> dropWhile(Function1<A, Boolean> var1);

    public Tuple2<Iterator<A>, Iterator<A>> partition(Function1<A, Boolean> var1);

    public Iterator<A> takeWhile(Function1<A, Boolean> var1);

    public <B> Iterator<B> partialMap(PartialFunction<Object, B> var1);

    public Iterator<A> filterNot(Function1<A, Boolean> var1);

    public Iterator<A> filter(Function1<A, Boolean> var1);

    public <B> Iterator<B> flatMap(Function1<A, Iterator<B>> var1);

    public <B> Object $plus$plus(Function0<Iterator<B>> var1);

    public <B> Iterator<B> map(Function1<A, B> var1);

    public Iterator<A> slice(int var1, int var2);

    public Iterator<A> drop(int var1);

    public Iterator<A> take(int var1);

    public A next();

    public boolean hasNext();

    public /* synthetic */ int sliding$default$2();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GroupedIterator<B>
    implements Iterator<Seq<B>>,
    ScalaObject {
        public final /* synthetic */ Iterator $outer;
        public Option scala$collection$Iterator$GroupedIterator$$pad;
        private boolean _partial;
        private boolean filled;
        private ArrayBuffer<B> buffer;
        private final int step;
        private final int size;
        private final Iterator<A> self;

        public GroupedIterator(Iterator<A> $outer, Iterator<A> self, int size2, int step) {
            this.self = self;
            this.size = size2;
            this.step = step;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Iterator$class.$init$(this);
            Predef$.MODULE$.require(size2 >= 1 && step >= 1);
            this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[0]));
            this.filled = false;
            this._partial = true;
            this.scala$collection$Iterator$GroupedIterator$$pad = None$.MODULE$;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean deliver$1(int howMany, int n, Seq seq2, IntRef intRef, IntRef intRef2) {
            if (howMany <= 0) return false;
            if (this.len$3(seq2, intRef, intRef2) <= this.gap()) return false;
            if (!this.isFirst$1(n)) {
                this.buffer.trimStart(Predef$.MODULE$.intWrapper(this.step).min(n));
            }
            int available = this.isFirst$1(n) ? this.len$3(seq2, intRef, intRef2) : Predef$.MODULE$.intWrapper(howMany).min(this.len$3(seq2, intRef, intRef2) - this.gap());
            this.buffer.$plus$plus$eq((Traversable)seq2.takeRight(available));
            this.filled = true;
            if (!true) return false;
            return true;
        }

        private final boolean incomplete$1(int n, Seq seq2, IntRef intRef, BooleanRef booleanRef, IntRef intRef2) {
            if ((intRef2.elem & 2) == 0) {
                booleanRef.elem = this.len$3(seq2, intRef, intRef2) < n;
                intRef2.elem |= 2;
            }
            return booleanRef.elem;
        }

        private final int len$3(Seq seq2, IntRef intRef, IntRef intRef2) {
            if ((intRef2.elem & 1) == 0) {
                intRef.elem = seq2.length();
                intRef2.elem |= 1;
            }
            return intRef.elem;
        }

        private final boolean isFirst$1(int n) {
            return n == 0;
        }

        public /* synthetic */ Iterator scala$collection$Iterator$GroupedIterator$$$outer() {
            return this.$outer;
        }

        @Override
        public List<B> next() {
            Serializable serializable2 = this.filled ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean(this.fill());
            this.filled = false;
            return this.buffer.toList();
        }

        @Override
        public boolean hasNext() {
            return this.filled || this.fill();
        }

        private boolean fill() {
            return this.self.hasNext() ? (this.buffer.isEmpty() ? this.go(this.size) : this.go(this.step)) : false;
        }

        private boolean go(int count$1) {
            int shortBy;
            IntRef bitmap$0$1 = new IntRef(0);
            int prevSize$1 = this.buffer.size();
            Seq res = Iterator$class.scala$collection$Iterator$$takeDestructively(this.self, count$1);
            Seq xs$1 = this.scala$collection$Iterator$GroupedIterator$$pad.isDefined() && !this.self.hasNext() ? ((shortBy = count$1 - res.length()) > 0 ? res.$plus$plus(this.padding(shortBy), Seq$.MODULE$.canBuildFrom()) : res) : res;
            IntRef len$lzy$1 = new IntRef(0);
            BooleanRef incomplete$lzy$1 = new BooleanRef(false);
            return xs$1.isEmpty() ? false : (this._partial ? this.deliver$1(Predef$.MODULE$.intWrapper(this.len$3(xs$1, len$lzy$1, bitmap$0$1)).min(this.size), prevSize$1, xs$1, len$lzy$1, bitmap$0$1) : (this.incomplete$1(count$1, xs$1, len$lzy$1, incomplete$lzy$1, bitmap$0$1) ? false : (this.isFirst$1(prevSize$1) ? this.deliver$1(this.len$3(xs$1, len$lzy$1, bitmap$0$1), prevSize$1, xs$1, len$lzy$1, bitmap$0$1) : this.deliver$1(Predef$.MODULE$.intWrapper(this.step).min(this.size), prevSize$1, xs$1, len$lzy$1, bitmap$0$1))));
        }

        private int gap() {
            return Predef$.MODULE$.intWrapper(this.step - this.size).max(0);
        }

        private List<B> padding(int x) {
            return (List)List$.MODULE$.fill(x, new GroupedIterator$$anonfun$padding$1(this));
        }

        public GroupedIterator<B> withPartial(boolean x) {
            this._partial = x;
            if (this._partial) {
                this.scala$collection$Iterator$GroupedIterator$$pad = None$.MODULE$;
            }
            return this;
        }

        public GroupedIterator<B> withPadding(Function0<B> x) {
            this.scala$collection$Iterator$GroupedIterator$$pad = new Some<Function0<B>>(x);
            return this;
        }

        @Override
        public /* synthetic */ int sliding$default$2() {
            return Iterator$class.sliding$default$2(this);
        }

        public void readInto(Object xs) {
            Iterator$class.readInto(this, xs);
        }

        public void readInto(Object xs, int start) {
            Iterator$class.readInto(this, xs, start);
        }

        public void readInto(Object xs, int start, int sz) {
            Iterator$class.readInto(this, xs, start, sz);
        }

        @Override
        public Object counted() {
            return Iterator$class.counted(this);
        }

        @Override
        public Seq collect() {
            return Iterator$class.collect(this);
        }

        @Override
        public int findIndexOf(Function1 p) {
            return Iterator$class.findIndexOf(this, p);
        }

        @Override
        public Object append(Iterator that) {
            return Iterator$class.append(this, that);
        }

        @Override
        public String toString() {
            return Iterator$class.toString(this);
        }

        @Override
        public StringBuilder addString(StringBuilder buf) {
            return Iterator$class.addString(this, buf);
        }

        @Override
        public StringBuilder addString(StringBuilder buf, String sep) {
            return Iterator$class.addString(this, buf, sep);
        }

        @Override
        public StringBuilder addString(StringBuilder buf, String start, String sep, String end) {
            return Iterator$class.addString(this, buf, start, sep, end);
        }

        @Override
        public String mkString() {
            return Iterator$class.mkString(this);
        }

        @Override
        public String mkString(String sep) {
            return Iterator$class.mkString(this, sep);
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return Iterator$class.mkString(this, start, sep, end);
        }

        @Override
        public Seq toSeq() {
            return Iterator$class.toSeq(this);
        }

        @Override
        public Stream toStream() {
            return Iterator$class.toStream(this);
        }

        @Override
        public List toList() {
            return Iterator$class.toList(this);
        }

        @Override
        public void copyToBuffer(Buffer dest) {
            Iterator$class.copyToBuffer(this, dest);
        }

        public void copyToArray(Object xs) {
            Iterator$class.copyToArray(this, xs);
        }

        public void copyToArray(Object xs, int start) {
            Iterator$class.copyToArray(this, xs, start);
        }

        public void copyToArray(Object xs, int start, int len) {
            Iterator$class.copyToArray(this, xs, start, len);
        }

        @Override
        public Object patch(int from2, Iterator patchElems, int replaced) {
            return Iterator$class.patch(this, from2, patchElems, replaced);
        }

        @Override
        public Tuple2 duplicate() {
            return Iterator$class.duplicate(this);
        }

        @Override
        public int length() {
            return Iterator$class.length(this);
        }

        @Override
        public GroupedIterator sliding(int size2, int step) {
            return Iterator$class.sliding(this, size2, step);
        }

        @Override
        public GroupedIterator grouped(int size2) {
            return Iterator$class.grouped(this, size2);
        }

        @Override
        public Object buffered() {
            return Iterator$class.buffered(this);
        }

        @Override
        public Option reduceRightOption(Function2 op) {
            return Iterator$class.reduceRightOption(this, op);
        }

        @Override
        public Option reduceLeftOption(Function2 op) {
            return Iterator$class.reduceLeftOption(this, op);
        }

        @Override
        public Object reduceRight(Function2 op) {
            return Iterator$class.reduceRight(this, op);
        }

        @Override
        public Object reduceLeft(Function2 op) {
            return Iterator$class.reduceLeft(this, op);
        }

        @Override
        public Object $colon$bslash(Object z, Function2 op) {
            return Iterator$class.$colon$bslash(this, z, op);
        }

        @Override
        public Object $div$colon(Object z, Function2 op) {
            return Iterator$class.$div$colon(this, z, op);
        }

        @Override
        public Object foldRight(Object z, Function2 op) {
            return Iterator$class.foldRight(this, z, op);
        }

        @Override
        public Object foldLeft(Object z, Function2 op) {
            return Iterator$class.foldLeft(this, z, op);
        }

        @Override
        public int indexOf(Object elem2) {
            return Iterator$class.indexOf(this, elem2);
        }

        @Override
        public int indexWhere(Function1 p) {
            return Iterator$class.indexWhere(this, p);
        }

        @Override
        public Option find(Function1 p) {
            return Iterator$class.find(this, p);
        }

        @Override
        public boolean contains(Object elem2) {
            return Iterator$class.contains(this, elem2);
        }

        @Override
        public boolean exists(Function1 p) {
            return Iterator$class.exists(this, p);
        }

        @Override
        public boolean forall(Function1 p) {
            return Iterator$class.forall(this, p);
        }

        @Override
        public void foreach(Function1 f) {
            Iterator$class.foreach(this, f);
        }

        @Override
        public Object zipAll(Iterator that, Object thisElem, Object thatElem) {
            return Iterator$class.zipAll(this, that, thisElem, thatElem);
        }

        @Override
        public Object zipWithIndex() {
            return Iterator$class.zipWithIndex(this);
        }

        @Override
        public Object padTo(int len, Object elem2) {
            return Iterator$class.padTo(this, len, elem2);
        }

        @Override
        public Object zip(Iterator that) {
            return Iterator$class.zip(this, that);
        }

        @Override
        public Iterator dropWhile(Function1 p) {
            return Iterator$class.dropWhile(this, p);
        }

        @Override
        public Tuple2 partition(Function1 p) {
            return Iterator$class.partition(this, p);
        }

        @Override
        public Iterator takeWhile(Function1 p) {
            return Iterator$class.takeWhile(this, p);
        }

        @Override
        public Iterator partialMap(PartialFunction pf) {
            return Iterator$class.partialMap(this, pf);
        }

        @Override
        public Iterator filterNot(Function1 p) {
            return Iterator$class.filterNot(this, p);
        }

        @Override
        public Iterator filter(Function1 p) {
            return Iterator$class.filter(this, p);
        }

        @Override
        public Iterator flatMap(Function1 f) {
            return Iterator$class.flatMap(this, f);
        }

        @Override
        public Object $plus$plus(Function0 that) {
            return Iterator$class.$plus$plus(this, that);
        }

        @Override
        public Iterator map(Function1 f) {
            return Iterator$class.map(this, f);
        }

        @Override
        public Iterator slice(int from2, int until2) {
            return Iterator$class.slice(this, from2, until2);
        }

        @Override
        public Iterator drop(int n) {
            return Iterator$class.drop(this, n);
        }

        @Override
        public Iterator take(int n) {
            return Iterator$class.take(this, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IteratorIteratorOps<A>
    implements ScalaObject {
        public final Iterator scala$collection$Iterator$IteratorIteratorOps$$its;

        public IteratorIteratorOps(Iterator<Iterator<A>> its) {
            this.scala$collection$Iterator$IteratorIteratorOps$$its = its;
        }

        public Iterator<A> flatten() {
            return new IteratorIteratorOps$$anon$15(this);
        }
    }
}

