/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.collection.Iterator;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static void $init$(HashTable $this) {
        $this.table_$eq(new HashEntry[HashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold());
    }

    public static final int index(HashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(HashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(HashTable $this, Object key) {
        return key.hashCode();
    }

    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, HashEntry>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                HashEntry hashEntry;
                if ((hashEntry = e) == null || hashEntry.equals(null)) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
            }
        }
        $this.threshold_$eq(HashTable$class.newThreshold($this, newSize));
    }

    private static int newThreshold(HashTable $this, int size2) {
        return (int)((long)size2 * (long)$this.loadFactor() / 1000L);
    }

    public static void clearTable(HashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    public static Iterator entries(HashTable $this) {
        return $this.entriesIterator();
    }

    public static Iterator entriesIterator(HashTable $this) {
        return new HashTable$.anon.1($this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static HashEntry removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        HashEntry hashEntry = e;
        if (hashEntry != null && !hashEntry.equals(null)) {
            if ($this.elemEquals(e.key(), key)) {
                $this.table()[h] = e.next();
                $this.tableSize_$eq($this.tableSize() - 1);
                return e;
            }
            HashEntry e1 = e.next();
            while (true) {
                HashEntry hashEntry2;
                if ((hashEntry2 = e1) == null || hashEntry2.equals(null) || $this.elemEquals(e1.key(), key)) {
                    HashEntry hashEntry3 = e1;
                    if (hashEntry3 == null || hashEntry3.equals(null)) break;
                    e.next_$eq(e1.next());
                    $this.tableSize_$eq($this.tableSize() - 1);
                    return e1;
                }
                e = e1;
                e1 = (HashEntry)e1.next();
            }
        }
        return null;
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        HashEntry hashEntry;
        while ((hashEntry = e) != null && !hashEntry.equals(null) && !$this.elemEquals(e.key(), key)) {
            e = e.next();
        }
        return e;
    }

    private static int powerOfTwo(HashTable $this, int target) {
        int c = target - 1;
        c |= c >>> 1;
        c |= c >>> 2;
        c |= c >>> 4;
        c |= c >>> 8;
        c |= c >>> 16;
        return c + 1;
    }

    private static int initialCapacity(HashTable $this) {
        return $this.initialSize() == 0 ? 1 : HashTable$class.powerOfTwo($this, $this.initialSize());
    }

    public static int initialThreshold(HashTable $this) {
        return HashTable$class.newThreshold($this, HashTable$class.initialCapacity($this));
    }

    public static int initialSize(HashTable $this) {
        return 16;
    }

    public static int loadFactor(HashTable $this) {
        return 750;
    }
}

