/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import scala.concurrent.forkjoin.LinkedTransferQueue;
import scala.concurrent.forkjoin.RecursiveAction;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinPool
extends AbstractExecutorService {
    private static final int shortMask = 65535;
    private static final int MAX_THREADS = Short.MAX_VALUE;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    public volatile ForkJoinWorkerThread[] workers;
    private final ReentrantLock workerLock;
    private final Condition termination;
    private Thread.UncaughtExceptionHandler ueh;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile WaitQueueNode spareStack;
    private final AtomicLong stealCount;
    private final LinkedTransferQueue<ForkJoinTask<?>> submissionQueue;
    private volatile WaitQueueNode syncStack;
    private volatile long eventCount;
    private final int poolNumber;
    private volatile int maxPoolSize;
    private volatile int parallelism;
    private volatile boolean locallyFifo;
    private volatile int workerCounts;
    private volatile int runControl;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    private volatile boolean maintainsParallelism;
    static final Unsafe _unsafe;
    static final long eventCountOffset;
    static final long workerCountsOffset;
    static final long runControlOffset;
    static final long syncStackOffset;
    static final long spareStackOffset;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    private static int totalCountOf(int n) {
        return n >>> 16;
    }

    private static int runningCountOf(int n) {
        return n & 0xFFFF;
    }

    private static int workerCountsFor(int n, int n2) {
        return (n << 16) + n2;
    }

    final void updateRunningCount(int n) {
        int n2;
        while (!this.casWorkerCounts(n2 = this.workerCounts, n2 + n)) {
        }
    }

    private void updateWorkerCount(int n) {
        int n2;
        int n3 = n + (n << 16);
        while (!this.casWorkerCounts(n2 = this.workerCounts, n2 + n3)) {
        }
    }

    private static int runStateOf(int n) {
        return n >>> 16;
    }

    private static int activeCountOf(int n) {
        return n & 0xFFFF;
    }

    private static int runControlFor(int n, int n2) {
        return (n << 16) + n2;
    }

    final boolean tryIncrementActiveCount() {
        int n = this.runControl;
        return this.casRunControl(n, n + 1);
    }

    final boolean tryDecrementActiveCount() {
        int n = this.runControl;
        int n2 = n - 1;
        if (!this.casRunControl(n, n2)) {
            return false;
        }
        if (ForkJoinPool.canTerminateOnShutdown(n2)) {
            this.terminateOnShutdown();
        }
        return true;
    }

    private static boolean canTerminateOnShutdown(int n) {
        return (n & -n) >>> 16 != 0;
    }

    private boolean transitionRunStateTo(int n) {
        int n2;
        do {
            if (ForkJoinPool.runStateOf(n2 = this.runControl) < n) continue;
            return false;
        } while (!this.casRunControl(n2, ForkJoinPool.runControlFor(n, ForkJoinPool.activeCountOf(n2))));
        return true;
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory) {
        this(Runtime.getRuntime().availableProcessors(), forkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory) {
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        ForkJoinPool.checkPermission();
        this.factory = forkJoinWorkerThreadFactory;
        this.parallelism = n;
        this.maxPoolSize = Short.MAX_VALUE;
        this.maintainsParallelism = true;
        this.poolNumber = poolNumberGenerator.incrementAndGet();
        this.workerLock = new ReentrantLock();
        this.termination = this.workerLock.newCondition();
        this.stealCount = new AtomicLong();
        this.submissionQueue = new LinkedTransferQueue();
    }

    private ForkJoinWorkerThread createWorker(int n) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.ueh;
        ForkJoinWorkerThread forkJoinWorkerThread = this.factory.newThread(this);
        if (forkJoinWorkerThread != null) {
            forkJoinWorkerThread.poolIndex = n;
            forkJoinWorkerThread.setDaemon(true);
            forkJoinWorkerThread.setAsyncMode(this.locallyFifo);
            forkJoinWorkerThread.setName("ForkJoinPool-" + this.poolNumber + "-worker-" + n);
            if (uncaughtExceptionHandler != null) {
                forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
        }
        return forkJoinWorkerThread;
    }

    private static int arraySizeFor(int n) {
        return n <= 1 ? 1 : 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public static ForkJoinWorkerThread[] copyOfWorkers(ForkJoinWorkerThread[] forkJoinWorkerThreadArray, int n) {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray2 = new ForkJoinWorkerThread[n];
        System.arraycopy(forkJoinWorkerThreadArray, 0, forkJoinWorkerThreadArray2, 0, Math.min(n, forkJoinWorkerThreadArray.length));
        return forkJoinWorkerThreadArray2;
    }

    private ForkJoinWorkerThread[] ensureWorkerArrayCapacity(int n) {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray == null) {
            this.workers = new ForkJoinWorkerThread[ForkJoinPool.arraySizeFor(n)];
            return this.workers;
        }
        if (n > forkJoinWorkerThreadArray.length) {
            this.workers = ForkJoinPool.copyOfWorkers(forkJoinWorkerThreadArray, ForkJoinPool.arraySizeFor(n));
            return this.workers;
        }
        return forkJoinWorkerThreadArray;
    }

    private void tryShrinkWorkerArray() {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray != null) {
            int n;
            int n2 = forkJoinWorkerThreadArray.length;
            for (n = n2 - 1; n >= 0 && forkJoinWorkerThreadArray[n] == null; --n) {
            }
            int n3 = ForkJoinPool.arraySizeFor(n + 1);
            if (n3 < n2) {
                this.workers = ForkJoinPool.copyOfWorkers(forkJoinWorkerThreadArray, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureWorkerInitialization() {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray == null) {
            ReentrantLock reentrantLock = this.workerLock;
            reentrantLock.lock();
            try {
                forkJoinWorkerThreadArray = this.workers;
                if (forkJoinWorkerThreadArray == null) {
                    int n = this.parallelism;
                    forkJoinWorkerThreadArray = this.ensureWorkerArrayCapacity(n);
                    for (int i = 0; i < n; ++i) {
                        ForkJoinWorkerThread forkJoinWorkerThread = this.createWorker(i);
                        if (forkJoinWorkerThread == null) continue;
                        forkJoinWorkerThreadArray[i] = forkJoinWorkerThread;
                        forkJoinWorkerThread.start();
                        this.updateWorkerCount(1);
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    private void createAndStartAddedWorkers() {
        this.resumeAllSpares();
        int n = this.parallelism;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.ensureWorkerArrayCapacity(n);
        int n2 = forkJoinWorkerThreadArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (forkJoinWorkerThreadArray[n3] != null) {
                ++n3;
                continue;
            }
            int n4 = this.workerCounts;
            int n5 = ForkJoinPool.totalCountOf(n4);
            int n6 = ForkJoinPool.runningCountOf(n4);
            if (n6 >= n || n5 >= n) break;
            if (!this.casWorkerCounts(n4, ForkJoinPool.workerCountsFor(n5 + 1, n6 + 1))) continue;
            ForkJoinWorkerThread forkJoinWorkerThread = this.createWorker(n3);
            if (forkJoinWorkerThread != null) {
                forkJoinWorkerThreadArray[n3++] = forkJoinWorkerThread;
                forkJoinWorkerThread.start();
                continue;
            }
            this.updateWorkerCount(-1);
            break;
        }
    }

    private <T> void doSubmit(ForkJoinTask<T> forkJoinTask) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        if (this.workers == null) {
            this.ensureWorkerInitialization();
        }
        this.submissionQueue.offer(forkJoinTask);
        this.signalIdleWorkers();
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        this.doSubmit(forkJoinTask);
        return forkJoinTask.join();
    }

    public <T> void execute(ForkJoinTask<T> forkJoinTask) {
        this.doSubmit(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        this.doSubmit(new AdaptedRunnable<Object>(runnable, null));
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        AdaptedCallable<T> adaptedCallable = new AdaptedCallable<T>(callable);
        this.doSubmit(adaptedCallable);
        return adaptedCallable;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        AdaptedRunnable<T> adaptedRunnable = new AdaptedRunnable<T>(runnable, t);
        this.doSubmit(adaptedRunnable);
        return adaptedRunnable;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        AdaptedRunnable<Object> adaptedRunnable = new AdaptedRunnable<Object>(runnable, null);
        this.doSubmit(adaptedRunnable);
        return adaptedRunnable;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        for (Callable<T> callable : collection) {
            arrayList.add(new AdaptedCallable<T>(callable));
        }
        this.invoke(new InvokeAll(arrayList));
        return arrayList;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            uncaughtExceptionHandler = this.ueh;
        }
        finally {
            reentrantLock.unlock();
        }
        return uncaughtExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ForkJoinPool.checkPermission();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = null;
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            uncaughtExceptionHandler2 = this.ueh;
            this.ueh = uncaughtExceptionHandler;
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray != null) {
                for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                    ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                    if (forkJoinWorkerThread == null) continue;
                    forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return uncaughtExceptionHandler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParallelism(int n) {
        ForkJoinPool.checkPermission();
        if (n <= 0 || n > this.maxPoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            if (!this.isTerminating()) {
                int n2 = this.parallelism;
                this.parallelism = n;
                if (n > n2) {
                    this.createAndStartAddedWorkers();
                } else {
                    this.trimSpares();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        this.signalIdleWorkers();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return ForkJoinPool.totalCountOf(this.workerCounts);
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaximumPoolSize(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.maxPoolSize = n;
    }

    public boolean getMaintainsParallelism() {
        return this.maintainsParallelism;
    }

    public void setMaintainsParallelism(boolean bl) {
        this.maintainsParallelism = bl;
    }

    public boolean setAsyncMode(boolean bl) {
        boolean bl2 = this.locallyFifo;
        this.locallyFifo = bl;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray != null) {
            for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                if (forkJoinWorkerThread == null) continue;
                forkJoinWorkerThread.setAsyncMode(bl);
            }
        }
        return bl2;
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        return ForkJoinPool.runningCountOf(this.workerCounts);
    }

    public int getActiveThreadCount() {
        return ForkJoinPool.activeCountOf(this.runControl);
    }

    final int getIdleThreadCount() {
        int n = ForkJoinPool.runningCountOf(this.workerCounts) - ForkJoinPool.activeCountOf(this.runControl);
        return n <= 0 ? 0 : n;
    }

    public boolean isQuiescent() {
        return ForkJoinPool.activeCountOf(this.runControl) == 0;
    }

    public long getStealCount() {
        return this.stealCount.get();
    }

    private void updateStealCount(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n = forkJoinWorkerThread.getAndClearStealCount();
        if (n != 0) {
            this.stealCount.addAndGet(n);
        }
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray != null) {
            for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                if (forkJoinWorkerThread == null) continue;
                l += (long)forkJoinWorkerThread.getQueueSize();
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        return this.submissionQueue.size();
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.submissionQueue.poll();
    }

    protected int drainTasksTo(Collection<ForkJoinTask<?>> collection) {
        int n = this.submissionQueue.drainTo(collection);
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray != null) {
            for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                if (forkJoinWorkerThread == null) continue;
                n += forkJoinWorkerThread.drainTasksTo(collection);
            }
        }
        return n;
    }

    public String toString() {
        int n = this.parallelism;
        int n2 = this.workerCounts;
        int n3 = this.runControl;
        long l = this.getStealCount();
        long l2 = this.getQueuedTaskCount();
        long l3 = this.getQueuedSubmissionCount();
        return super.toString() + "[" + ForkJoinPool.runStateToString(ForkJoinPool.runStateOf(n3)) + ", parallelism = " + n + ", size = " + ForkJoinPool.totalCountOf(n2) + ", active = " + ForkJoinPool.activeCountOf(n3) + ", running = " + ForkJoinPool.runningCountOf(n2) + ", steals = " + l + ", tasks = " + l2 + ", submissions = " + l3 + "]";
    }

    private static String runStateToString(int n) {
        switch (n) {
            case 0: {
                return "Running";
            }
            case 1: {
                return "Shutting down";
            }
            case 2: {
                return "Terminating";
            }
            case 3: {
                return "Terminated";
            }
        }
        throw new Error("Unknown run state");
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.transitionRunStateTo(1);
        if (ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            this.terminateOnShutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.terminate();
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return ForkJoinPool.runStateOf(this.runControl) == 3;
    }

    public boolean isTerminating() {
        return ForkJoinPool.runStateOf(this.runControl) >= 2;
    }

    @Override
    public boolean isShutdown() {
        return ForkJoinPool.runStateOf(this.runControl) >= 1;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void workerTerminated(ForkJoinWorkerThread forkJoinWorkerThread) {
        this.updateStealCount(forkJoinWorkerThread);
        this.updateWorkerCount(-1);
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray != null) {
                int n = forkJoinWorkerThread.poolIndex;
                if (n >= 0 && n < forkJoinWorkerThreadArray.length && forkJoinWorkerThreadArray[n] == forkJoinWorkerThread) {
                    forkJoinWorkerThreadArray[n] = null;
                }
                if (ForkJoinPool.totalCountOf(this.workerCounts) == 0) {
                    this.terminate();
                    this.transitionRunStateTo(3);
                    this.termination.signalAll();
                } else if (!this.isTerminating()) {
                    this.tryShrinkWorkerArray();
                    this.tryResumeSpare(true);
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        this.signalIdleWorkers();
    }

    private void terminate() {
        if (this.transitionRunStateTo(2)) {
            this.stopAllWorkers();
            this.resumeAllSpares();
            this.signalIdleWorkers();
            this.cancelQueuedSubmissions();
            this.cancelQueuedWorkerTasks();
            this.interruptUnterminatedWorkers();
            this.signalIdleWorkers();
        }
    }

    private void terminateOnShutdown() {
        if (!this.hasQueuedSubmissions() && ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            this.terminate();
        }
    }

    private void cancelQueuedSubmissions() {
        ForkJoinTask<?> forkJoinTask;
        while ((forkJoinTask = this.pollSubmission()) != null) {
            forkJoinTask.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueuedWorkerTasks() {
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray != null) {
                for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                    ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                    if (forkJoinWorkerThread == null) continue;
                    forkJoinWorkerThread.cancelTasks();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers() {
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray != null) {
                for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                    ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                    if (forkJoinWorkerThread == null) continue;
                    forkJoinWorkerThread.shutdownNow();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptUnterminatedWorkers() {
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray != null) {
                for (int i = 0; i < forkJoinWorkerThreadArray.length; ++i) {
                    ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[i];
                    if (forkJoinWorkerThread == null || forkJoinWorkerThread.isTerminated()) continue;
                    try {
                        forkJoinWorkerThread.interrupt();
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    final long ensureSync() {
        WaitQueueNode waitQueueNode;
        long l = this.eventCount;
        while ((waitQueueNode = this.syncStack) != null && waitQueueNode.count < l) {
            if (!this.casBarrierStack(waitQueueNode, null)) continue;
            do {
                waitQueueNode.signal();
            } while ((waitQueueNode = waitQueueNode.next) != null);
            break;
        }
        return l;
    }

    private void signalIdleWorkers() {
        long l;
        while (!this.casEventCount(l = this.eventCount, l + 1L)) {
        }
        this.ensureSync();
    }

    final void signalWork() {
        WaitQueueNode waitQueueNode;
        long l;
        if (!(this.syncStack == null || !this.casEventCount(l = this.eventCount, l + 1L) || (waitQueueNode = this.syncStack) == null || waitQueueNode.count > l || this.casBarrierStack(waitQueueNode, waitQueueNode.next) && waitQueueNode.signal())) {
            this.ensureSync();
        }
    }

    final void sync(ForkJoinWorkerThread forkJoinWorkerThread) {
        this.updateStealCount(forkJoinWorkerThread);
        while (!(forkJoinWorkerThread.isShutdown() || this.isTerminating() || this.suspendIfSpare(forkJoinWorkerThread))) {
            long l;
            WaitQueueNode waitQueueNode;
            long l2 = forkJoinWorkerThread.lastEventCount;
            WaitQueueNode waitQueueNode2 = null;
            while (this.eventCount == l2 && ((waitQueueNode = this.syncStack) == null || waitQueueNode.count == l2)) {
                if (waitQueueNode2 == null) {
                    waitQueueNode2 = new WaitQueueNode(l2, forkJoinWorkerThread);
                }
                if (!this.casBarrierStack(waitQueueNode2.next = waitQueueNode, waitQueueNode2)) continue;
                waitQueueNode2.awaitSyncRelease(this);
                break;
            }
            if ((l = this.ensureSync()) == l2) continue;
            forkJoinWorkerThread.lastEventCount = l;
            break;
        }
    }

    final boolean syncIsReleasable(WaitQueueNode waitQueueNode) {
        long l = waitQueueNode.count;
        if (!(Thread.interrupted() || waitQueueNode.thread == null || waitQueueNode.next == null && ForkJoinWorkerThread.hasQueuedTasks(this.workers) || this.eventCount != l)) {
            return false;
        }
        if (waitQueueNode.thread != null) {
            waitQueueNode.thread = null;
            long l2 = this.eventCount;
            if (l <= l2) {
                this.casEventCount(l2, l2 + 1L);
            }
        }
        return true;
    }

    final boolean hasNewSyncEvent(ForkJoinWorkerThread forkJoinWorkerThread) {
        long l = forkJoinWorkerThread.lastEventCount;
        long l2 = this.ensureSync();
        if (l2 == l) {
            return false;
        }
        forkJoinWorkerThread.lastEventCount = l2;
        return true;
    }

    final boolean preJoin(ForkJoinTask<?> forkJoinTask, boolean bl) {
        bl &= this.maintainsParallelism;
        boolean bl2 = false;
        while (this.spareStack == null || !this.tryResumeSpare(bl2)) {
            int n = this.workerCounts;
            if (!bl2 && !(bl2 = this.casWorkerCounts(n--, n))) continue;
            if (!this.needSpare(n, bl)) break;
            if (forkJoinTask.status < 0) {
                return true;
            }
            if (!this.tryAddSpare(n)) continue;
            break;
        }
        return false;
    }

    final boolean preBlock(ManagedBlocker managedBlocker, boolean bl) {
        bl &= this.maintainsParallelism;
        boolean bl2 = false;
        while (this.spareStack == null || !this.tryResumeSpare(bl2)) {
            int n = this.workerCounts;
            if (!bl2 && !(bl2 = this.casWorkerCounts(n--, n))) continue;
            if (!this.needSpare(n, bl)) break;
            if (managedBlocker.isReleasable()) {
                return true;
            }
            if (!this.tryAddSpare(n)) continue;
            break;
        }
        return false;
    }

    private boolean needSpare(int n, boolean bl) {
        int n2 = this.parallelism;
        int n3 = ForkJoinPool.runningCountOf(n);
        int n4 = ForkJoinPool.totalCountOf(n);
        int n5 = n2 - n3;
        int n6 = n4 - n2;
        return n4 < this.maxPoolSize && (n3 == 0 || n6 < 0 || bl && n5 > n6 && ForkJoinWorkerThread.hasQueuedTasks(this.workers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddSpare(int n) {
        boolean bl;
        block7: {
            ReentrantLock reentrantLock = this.workerLock;
            int n2 = ForkJoinPool.runningCountOf(n);
            int n3 = ForkJoinPool.totalCountOf(n);
            bl = false;
            boolean bl2 = false;
            try {
                int n4;
                int n5;
                int n6;
                do {
                    n6 = this.workerCounts;
                    n5 = ForkJoinPool.totalCountOf(n6);
                    n4 = ForkJoinPool.runningCountOf(n6);
                    if (n4 > n2) break block7;
                    if (n5 > n3) {
                    } else if (bl2 || (bl2 = reentrantLock.tryLock())) continue;
                    break block7;
                } while (!this.casWorkerCounts(n6, ForkJoinPool.workerCountsFor(n5 + 1, n4 + 1)));
                this.createAndStartSpare(n5);
                bl = true;
            }
            finally {
                if (bl2) {
                    reentrantLock.unlock();
                }
            }
        }
        return bl;
    }

    private void createAndStartSpare(int n) {
        ForkJoinWorkerThread forkJoinWorkerThread = null;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.ensureWorkerArrayCapacity(n + 1);
        int n2 = forkJoinWorkerThreadArray.length;
        if (n < n2 && forkJoinWorkerThreadArray[n] != null) {
            for (n = 0; n < n2 && forkJoinWorkerThreadArray[n] != null; ++n) {
            }
        }
        if (n < n2 && !this.isTerminating() && (forkJoinWorkerThread = this.createWorker(n)) != null) {
            forkJoinWorkerThreadArray[n] = forkJoinWorkerThread;
            forkJoinWorkerThread.start();
        } else {
            this.updateWorkerCount(-1);
        }
        this.signalIdleWorkers();
    }

    private boolean suspendIfSpare(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n;
        WaitQueueNode waitQueueNode = null;
        while (this.parallelism < ForkJoinPool.runningCountOf(n = this.workerCounts)) {
            if (waitQueueNode == null) {
                waitQueueNode = new WaitQueueNode(0L, forkJoinWorkerThread);
            }
            if (!this.casWorkerCounts(n, n - 1)) continue;
            while (!this.casSpareStack(waitQueueNode.next = this.spareStack, waitQueueNode)) {
            }
            waitQueueNode.awaitSpareRelease();
            return true;
        }
        return false;
    }

    private boolean tryResumeSpare(boolean bl) {
        WaitQueueNode waitQueueNode;
        while ((waitQueueNode = this.spareStack) != null) {
            if (!this.casSpareStack(waitQueueNode, waitQueueNode.next)) continue;
            if (bl) {
                this.updateRunningCount(1);
            }
            waitQueueNode.signal();
            return true;
        }
        return false;
    }

    private boolean resumeAllSpares() {
        WaitQueueNode waitQueueNode;
        while ((waitQueueNode = this.spareStack) != null) {
            if (!this.casSpareStack(waitQueueNode, null)) continue;
            do {
                this.updateRunningCount(1);
                waitQueueNode.signal();
            } while ((waitQueueNode = waitQueueNode.next) != null);
            return true;
        }
        return false;
    }

    private void trimSpares() {
        WaitQueueNode waitQueueNode;
        int n = ForkJoinPool.totalCountOf(this.workerCounts) - this.parallelism;
        while (n > 0 && (waitQueueNode = this.spareStack) != null) {
            if (!this.casSpareStack(waitQueueNode, null)) continue;
            do {
                this.updateRunningCount(1);
                ForkJoinWorkerThread forkJoinWorkerThread = waitQueueNode.thread;
                if (forkJoinWorkerThread != null && n > 0 && ForkJoinPool.runningCountOf(this.workerCounts) > 0 && forkJoinWorkerThread.shutdown()) {
                    --n;
                }
                waitQueueNode.signal();
            } while ((waitQueueNode = waitQueueNode.next) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker managedBlocker, boolean bl) throws InterruptedException {
        ForkJoinPool forkJoinPool;
        Thread thread = Thread.currentThread();
        ForkJoinPool forkJoinPool2 = forkJoinPool = thread instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)thread).pool : null;
        if (!managedBlocker.isReleasable()) {
            try {
                if (forkJoinPool == null || !forkJoinPool.preBlock(managedBlocker, bl)) {
                    ForkJoinPool.awaitBlocker(managedBlocker);
                }
            }
            finally {
                if (forkJoinPool != null) {
                    forkJoinPool.updateRunningCount(1);
                }
            }
        }
    }

    private static void awaitBlocker(ManagedBlocker managedBlocker) throws InterruptedException {
        while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new AdaptedRunnable<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return ForkJoinPool.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field2 = Unsafe.class.getDeclaredField("theUnsafe");
        field2.setAccessible(true);
        return (Unsafe)field2.get(null);
    }

    private static long fieldOffset(String string2) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(ForkJoinPool.class.getDeclaredField(string2));
    }

    private boolean casEventCount(long l, long l2) {
        return _unsafe.compareAndSwapLong(this, eventCountOffset, l, l2);
    }

    private boolean casWorkerCounts(int n, int n2) {
        return _unsafe.compareAndSwapInt(this, workerCountsOffset, n, n2);
    }

    private boolean casRunControl(int n, int n2) {
        return _unsafe.compareAndSwapInt(this, runControlOffset, n, n2);
    }

    private boolean casSpareStack(WaitQueueNode waitQueueNode, WaitQueueNode waitQueueNode2) {
        return _unsafe.compareAndSwapObject(this, spareStackOffset, waitQueueNode, waitQueueNode2);
    }

    private boolean casBarrierStack(WaitQueueNode waitQueueNode, WaitQueueNode waitQueueNode2) {
        return _unsafe.compareAndSwapObject(this, syncStackOffset, waitQueueNode, waitQueueNode2);
    }

    static {
        try {
            _unsafe = ForkJoinPool.getUnsafe();
            eventCountOffset = ForkJoinPool.fieldOffset("eventCount");
            workerCountsOffset = ForkJoinPool.fieldOffset("workerCounts");
            runControlOffset = ForkJoinPool.fieldOffset("runControl");
            syncStackOffset = ForkJoinPool.fieldOffset("syncStack");
            spareStackOffset = ForkJoinPool.fieldOffset("spareStack");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not initialize intrinsics", throwable);
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WaitQueueNode {
        WaitQueueNode next;
        volatile ForkJoinWorkerThread thread;
        final long count;

        WaitQueueNode(long l, ForkJoinWorkerThread forkJoinWorkerThread) {
            this.count = l;
            this.thread = forkJoinWorkerThread;
        }

        boolean signal() {
            ForkJoinWorkerThread forkJoinWorkerThread = this.thread;
            if (forkJoinWorkerThread == null) {
                return false;
            }
            this.thread = null;
            LockSupport.unpark(forkJoinWorkerThread);
            return true;
        }

        void awaitSyncRelease(ForkJoinPool forkJoinPool) {
            while (this.thread != null && !forkJoinPool.syncIsReleasable(this)) {
                LockSupport.park(this);
            }
        }

        void awaitSpareRelease() {
            while (this.thread != null) {
                if (Thread.interrupted()) continue;
                LockSupport.park(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;

        InvokeAll(ArrayList<ForkJoinTask<T>> arrayList) {
            this.tasks = arrayList;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<T> callable;
        T result;

        AdaptedCallable(Callable<T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;

        AdaptedRunnable(Runnable runnable, T t) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = t;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            try {
                return new ForkJoinWorkerThread(forkJoinPool);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return null;
            }
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

