/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.actors.Debug$;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpService$;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private final NetKernel kernel;
    private final HashMap<Node, TcpServiceWorker> connections;
    private boolean shouldTerminate;
    private final HashMap<Node, List<byte[]>> pendingSends;
    private final Node internalNode;
    private final JavaSerializer serializer;
    private final int port;

    public static final void BufSize_$eq(int n) {
        TcpService$.MODULE$.BufSize_$eq(n);
    }

    public static final int BufSize() {
        return TcpService$.MODULE$.BufSize();
    }

    public static final int generatePort() {
        return TcpService$.MODULE$.generatePort();
    }

    public static final TcpService apply(int n, ClassLoader classLoader) {
        return TcpService$.MODULE$.apply(n, classLoader);
    }

    public TcpService(int port, ClassLoader cl) {
        this.port = port;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this, cl);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), port);
        this.pendingSends = new HashMap();
        this.shouldTerminate = false;
        this.connections = new HashMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object liftedTree1$1(Node node, byte[] byArray) {
        try {
            Object object;
            TcpServiceWorker newWorker$1 = this.connect(node);
            newWorker$1.transmit(byArray);
            Option<List<byte[]>> temp9 = this.pendingSends().get(node);
            None$ none$ = None$.MODULE$;
            if (!(none$ != null ? !none$.equals(temp9) : temp9 != null)) {
                if (!true) throw new MatchError(temp9.toString());
                object = BoxedUnit.UNIT;
                return object;
            } else {
                if (!(temp9 instanceof Some)) throw new MatchError(temp9.toString());
                Some temp11 = (Some)temp9;
                List temp12 = (List)temp11.x();
                if (!true) throw new MatchError(temp9.toString());
                temp12.foreach(new $anonfun$liftedTree1$1$1(this, newWorker$1));
                object = this.pendingSends().$minus$eq((Object)node);
            }
            return object;
        }
        catch (SecurityException securityException) {
            return BoxedUnit.UNIT;
        }
        catch (IOException iOException) {
            this.bufferMsg$1(iOException, node, byArray);
            return BoxedUnit.UNIT;
        }
        catch (UnknownHostException unknownHostException) {
            this.bufferMsg$1(unknownHostException, node, byArray);
            return BoxedUnit.UNIT;
        }
    }

    private final void bufferMsg$1(Throwable t, Node node, byte[] byArray) {
        Option<List<byte[]>> temp5;
        block5: {
            block6: {
                block4: {
                    block2: {
                        block3: {
                            temp5 = this.pendingSends().get(node);
                            None$ none$ = None$.MODULE$;
                            if (none$ != null ? !none$.equals(temp5) : temp5 != null) break block2;
                            if (!true) break block3;
                            this.pendingSends().$plus$eq(Predef$Pair$.MODULE$.apply(node, List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{byArray}))));
                            break block4;
                        }
                        throw new MatchError(temp5.toString());
                    }
                    if (!(temp5 instanceof Some)) break block5;
                    Some temp7 = (Some)temp5;
                    List temp8 = (List)temp7.x();
                    if (!this.gd1$1(temp8)) break block6;
                    this.pendingSends().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(node, temp8.$colon$colon(byArray)));
                }
                return;
            }
            throw new MatchError(temp5.toString());
        }
        throw new MatchError(temp5.toString());
    }

    private final /* synthetic */ boolean gd1$1(List list2) {
        return list2.length() < TcpService$.MODULE$.BufSize();
    }

    public void nodeDown(Node mnode) {
        synchronized (this) {
            this.connections().$minus$eq((Object)mnode);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReachable(Node node) {
        boolean bl;
        if (this.isConnected(node)) {
            bl = true;
        } else {
            void var2_2;
            boolean exceptionResult2;
            try {
                this.connect(node);
                return true;
            }
            catch (SecurityException securityException) {
                exceptionResult2 = false;
            }
            catch (IOException iOException) {
                exceptionResult2 = false;
            }
            catch (UnknownHostException unknownHostException) {
                exceptionResult2 = false;
            }
            bl = var2_2;
        }
        return bl;
    }

    public void disconnectNode(Node n) {
        synchronized (this) {
            Option<TcpServiceWorker> temp20;
            block10: {
                block11: {
                    block9: {
                        block8: {
                            temp20 = this.connections().get(n);
                            None$ none$ = None$.MODULE$;
                            if (none$ != null ? !none$.equals(temp20) : temp20 != null) break block8;
                            if (!true) {
                                throw new MatchError(temp20.toString());
                            }
                            break block9;
                        }
                        if (!(temp20 instanceof Some)) break block10;
                        Some temp22 = (Some)temp20;
                        TcpServiceWorker temp23 = (TcpServiceWorker)temp22.x();
                        if (!true) break block11;
                        this.connections().$minus$eq((Object)n);
                        temp23.halt();
                    }
                    return;
                }
                throw new MatchError(temp20.toString());
            }
            throw new MatchError(temp20.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public TcpServiceWorker connect(Node n) {
        synchronized (this) {
            void var3_3;
            Socket socket = new Socket(n.address(), n.port());
            TcpServiceWorker worker = new TcpServiceWorker(this, socket);
            worker.sendNode(n);
            worker.start();
            this.addConnection(n, worker);
            return (TcpServiceWorker)var3_3;
        }
    }

    public boolean isConnected(Node n) {
        synchronized (this) {
            boolean bl = !this.connections().get(n).isEmpty();
            return bl;
        }
    }

    public Option<TcpServiceWorker> getConnection(Node n) {
        synchronized (this) {
            return this.connections().get(n);
        }
    }

    public HashMap<Node, TcpServiceWorker> addConnection(Node node, TcpServiceWorker worker) {
        synchronized (this) {
            return (HashMap)this.connections().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(node, worker));
        }
    }

    private HashMap<Node, TcpServiceWorker> connections() {
        return this.connections;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            ServerSocket socket = new ServerSocket(this.port);
            while (true) {
                if (this.shouldTerminate()) {
                    Debug$.MODULE$.info(new StringAdd(this).$plus(": shutting down..."));
                    this.connections().foreach(new $anonfun$run$1(this));
                    return;
                }
                int n = this.port;
                Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": waiting for new connection on port ")).append(BoxesRunTime.boxToInteger(n)).append((Object)"...").toString());
                Socket nextClient = socket.accept();
                if (this.shouldTerminate()) {
                    nextClient.close();
                    continue;
                }
                TcpServiceWorker worker = new TcpServiceWorker(this, nextClient);
                Debug$.MODULE$.info(new StringBuilder().append((Object)"Started new ").append(worker).toString());
                worker.readNode();
                worker.start();
                continue;
                break;
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(exception).toString());
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
            this.connections().foreach(new $anonfun$run$1(this));
        }
        return;
        catch (Throwable throwable) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
            this.connections().foreach(new $anonfun$run$1(this));
            throw throwable;
        }
    }

    private void shouldTerminate_$eq(boolean bl) {
        this.shouldTerminate = bl;
    }

    private boolean shouldTerminate() {
        return this.shouldTerminate;
    }

    @Override
    public void terminate() {
        this.shouldTerminate_$eq(true);
        try {
            new Socket(this.internalNode().address(), this.internalNode().port());
        }
        catch (ConnectException connectException) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(connectException).toString());
        }
    }

    @Override
    public void send(Node node$1, byte[] data$1) {
        synchronized (this) {
            Option<TcpServiceWorker> temp13;
            block8: {
                block9: {
                    block7: {
                        Object object;
                        block5: {
                            block6: {
                                temp13 = this.getConnection(node$1);
                                None$ none$ = None$.MODULE$;
                                if (none$ != null ? !none$.equals(temp13) : temp13 != null) break block5;
                                if (!true) break block6;
                                object = this.liftedTree1$1(node$1, data$1);
                                break block7;
                            }
                            throw new MatchError(temp13.toString());
                        }
                        if (!(temp13 instanceof Some)) break block8;
                        Some temp15 = (Some)temp13;
                        TcpServiceWorker temp16 = (TcpServiceWorker)temp15.x();
                        if (!true) break block9;
                        temp16.transmit(data$1);
                        object = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(temp13.toString());
            }
            throw new MatchError(temp13.toString());
        }
    }

    private HashMap<Node, List<byte[]>> pendingSends() {
        return this.pendingSends;
    }

    @Override
    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    @Override
    public JavaSerializer serializer() {
        return this.serializer;
    }

    @Override
    public void scala$actors$remote$Service$_setter_$kernel_$eq(NetKernel netKernel) {
        this.kernel = netKernel;
    }

    @Override
    public NetKernel kernel() {
        return this.kernel;
    }
}

