/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import org.scalatools.testing.Framework;
import org.scalatools.testing.Runner2;
import org.scalatools.testing.TestFingerprint;
import sbt.EventHandlerWrapper;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Logger;
import sbt.testing.Runner;
import sbt.testing.SubclassFingerprint;
import sbt.testing.Task;
import sbt.testing.TaskDef;

final class RunnerWrapper
implements Runner {
    private final Framework oldFramework;
    private final ClassLoader testClassLoader;
    private final String[] args;

    RunnerWrapper(Framework oldFramework, ClassLoader testClassLoader, String[] args) {
        this.oldFramework = oldFramework;
        this.testClassLoader = testClassLoader;
        this.args = args;
    }

    public Task[] tasks(TaskDef[] taskDefs) {
        int length = taskDefs.length;
        Task[] tasks = new Task[length];
        for (int i = 0; i < length; ++i) {
            TaskDef taskDef = taskDefs[i];
            tasks[i] = this.createTask(taskDef);
        }
        return tasks;
    }

    private Task createTask(final TaskDef taskDef) {
        return new Task(){

            public String[] tags() {
                return new String[0];
            }

            private org.scalatools.testing.Logger createOldLogger(final Logger logger) {
                return new org.scalatools.testing.Logger(){

                    public boolean ansiCodesSupported() {
                        return logger.ansiCodesSupported();
                    }

                    public void error(String msg) {
                        logger.error(msg);
                    }

                    public void warn(String msg) {
                        logger.warn(msg);
                    }

                    public void info(String msg) {
                        logger.info(msg);
                    }

                    public void debug(String msg) {
                        logger.debug(msg);
                    }

                    public void trace(Throwable t) {
                        logger.trace(t);
                    }
                };
            }

            private void runRunner(org.scalatools.testing.Runner runner, Fingerprint fingerprint, EventHandler eventHandler) {
                final SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
                TestFingerprint oldFingerprint = new TestFingerprint(){

                    public boolean isModule() {
                        return subclassFingerprint.isModule();
                    }

                    public String superClassName() {
                        return subclassFingerprint.superclassName();
                    }
                };
                String name = taskDef.fullyQualifiedName();
                runner.run(name, oldFingerprint, (org.scalatools.testing.EventHandler)new EventHandlerWrapper(eventHandler, name, (Fingerprint)subclassFingerprint), RunnerWrapper.this.args);
            }

            private void runRunner2(Runner2 runner, Fingerprint fingerprint, EventHandler eventHandler) {
                Object oldFingerprint;
                if (fingerprint instanceof SubclassFingerprint) {
                    final SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
                    oldFingerprint = new org.scalatools.testing.SubclassFingerprint(){

                        public boolean isModule() {
                            return subclassFingerprint.isModule();
                        }

                        public String superClassName() {
                            return subclassFingerprint.superclassName();
                        }
                    };
                } else {
                    final AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
                    oldFingerprint = new org.scalatools.testing.AnnotatedFingerprint(){

                        public boolean isModule() {
                            return annotatedFingerprint.isModule();
                        }

                        public String annotationName() {
                            return annotatedFingerprint.annotationName();
                        }
                    };
                }
                String name = taskDef.fullyQualifiedName();
                runner.run(name, (org.scalatools.testing.Fingerprint)oldFingerprint, (org.scalatools.testing.EventHandler)new EventHandlerWrapper(eventHandler, name, fingerprint), RunnerWrapper.this.args);
            }

            public Task[] execute(EventHandler eventHandler, Logger[] loggers) {
                int length = loggers.length;
                org.scalatools.testing.Logger[] oldLoggers = new org.scalatools.testing.Logger[length];
                for (int i = 0; i < length; ++i) {
                    oldLoggers[i] = this.createOldLogger(loggers[i]);
                }
                org.scalatools.testing.Runner runner = RunnerWrapper.this.oldFramework.testRunner(RunnerWrapper.this.testClassLoader, oldLoggers);
                Fingerprint fingerprint = taskDef.fingerprint();
                if (runner instanceof Runner2) {
                    this.runRunner2((Runner2)runner, fingerprint, eventHandler);
                } else {
                    this.runRunner(runner, fingerprint, eventHandler);
                }
                return new Task[0];
            }

            public TaskDef taskDef() {
                return taskDef;
            }
        };
    }

    public String done() {
        return "";
    }

    public String[] args() {
        return this.args;
    }

    public String[] remoteArgs() {
        return new String[0];
    }
}

