/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.cql;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.scassandra.cql.CqlType;

public class MapType
extends CqlType {
    private CqlType keyType;
    private CqlType valueType;

    public static MapType map(CqlType keyType, CqlType valueType) {
        return new MapType(keyType, valueType);
    }

    MapType(CqlType keyType, CqlType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public String serialise() {
        return String.format("map<%s,%s>", this.keyType.serialise(), this.valueType.serialise());
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected instanceof Map) {
            Map typedExpected = (Map)expected;
            final Map actualMap = (Map)actual;
            if (typedExpected.size() != actualMap.size()) {
                return false;
            }
            for (final Map.Entry eachExpected : typedExpected.entrySet()) {
                boolean match = Iterables.any(actualMap.keySet(), (Predicate)new Predicate<Object>(){

                    public boolean apply(Object eachActualKey) {
                        Object eachActual = actualMap.get(eachActualKey);
                        return MapType.this.keyType.equals(eachExpected.getKey(), eachActualKey) && MapType.this.valueType.equals(eachExpected.getValue(), eachActual);
                    }
                });
                if (match) continue;
                return false;
            }
            return true;
        }
        throw this.throwInvalidType(expected, actual, this);
    }

    public String toString() {
        return this.serialise();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType1 = (MapType)o;
        if (this.keyType != null ? !this.keyType.equals(mapType1.keyType) : mapType1.keyType != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals(mapType1.valueType) : mapType1.valueType != null);
    }

    public int hashCode() {
        int result = this.keyType != null ? this.keyType.hashCode() : 0;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    public CqlType getKeyType() {
        return this.keyType;
    }

    public CqlType getValueType() {
        return this.valueType;
    }
}

