/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.scijava.nativelib.DefaultJniExtractor;
import org.scijava.nativelib.JniExtractor;
import org.scijava.nativelib.NativeLibraryUtil;
import org.scijava.nativelib.WebappJniExtractor;

public class NativeLoader {
    private static JniExtractor jniExtractor = null;

    public static void loadLibrary(String libname, String ... searchPaths) throws IOException {
        try {
            System.loadLibrary(libname);
            return;
        }
        catch (UnsatisfiedLinkError e) {
            LinkedList<String> libPaths = searchPaths == null ? new LinkedList<String>() : new LinkedList<String>(Arrays.asList(searchPaths));
            libPaths.add(0, "natives/");
            libPaths.add(1, "");
            libPaths.add(2, "META-INF/lib");
            for (String libPath : libPaths) {
                File extracted = jniExtractor.extractJni(NativeLibraryUtil.getPlatformLibraryPath(libPath), libname);
                if (extracted == null) continue;
                System.load(extracted.getAbsolutePath());
                return;
            }
            throw new IOException("Couldn't load library library " + libname);
        }
    }

    public static void extractRegistered() throws IOException {
        jniExtractor.extractRegistered();
    }

    public static JniExtractor getJniExtractor() {
        return jniExtractor;
    }

    public static void setJniExtractor(JniExtractor jniExtractor) {
        NativeLoader.jniExtractor = jniExtractor;
    }

    static {
        try {
            jniExtractor = NativeLoader.class.getClassLoader() == ClassLoader.getSystemClassLoader() ? new DefaultJniExtractor(null) : new WebappJniExtractor("Classloader");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

