/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.ResponseBuffer;
import org.simpleframework.http.core.ResponseMessage;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Sender;
import org.simpleframework.transport.trace.Trace;

class ResponseEntity
extends ResponseMessage
implements Response {
    private ResponseBuffer buffer;
    private Conversation support;
    private Channel channel;
    private Monitor monitor;
    private Sender sender;
    private Trace trace;
    private boolean committed;

    public ResponseEntity(Request request, Entity entity, Monitor monitor) {
        this.support = new Conversation(request, this);
        this.buffer = new ResponseBuffer((Response)this, this.support, entity, monitor);
        this.channel = entity.getChannel();
        this.sender = this.channel.getSender();
        this.trace = this.channel.getTrace();
        this.monitor = monitor;
    }

    public long getResponseTime() {
        return this.monitor.getTime();
    }

    public Object getAttribute(Object name) {
        return this.getAttributes().get(name);
    }

    public Map getAttributes() {
        return this.channel.getAttributes();
    }

    public void setContentLength(long length) {
        this.setValue("Content-Length", String.valueOf(length));
    }

    private String getCharset() {
        ContentType type = this.getContentType();
        if (type == null) {
            return "ISO-8859-1";
        }
        if (type.getCharset() == null) {
            return "ISO-8859-1";
        }
        return type.getCharset();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.buffer;
    }

    public OutputStream getOutputStream(int size) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return this.buffer;
    }

    public PrintStream getPrintStream() throws IOException {
        return this.getPrintStream(0, this.getCharset());
    }

    public PrintStream getPrintStream(int size) throws IOException {
        return this.getPrintStream(size, this.getCharset());
    }

    private PrintStream getPrintStream(int size, String charset) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return new PrintStream((OutputStream)this.buffer, false, charset);
    }

    public WritableByteChannel getByteChannel() throws IOException {
        return this.buffer;
    }

    public WritableByteChannel getByteChannel(int size) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return this.buffer;
    }

    public boolean isKeepAlive() {
        return this.support.isKeepAlive();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void commit() throws IOException {
        if (!this.committed) {
            String header = this.toString();
            byte[] message = header.getBytes("UTF-8");
            this.trace.trace((Object)ContainerEvent.WRITE_HEADER, header);
            this.sender.send(message);
            this.committed = true;
        }
    }

    public void reset() throws IOException {
        this.buffer.reset();
    }

    public void close() throws IOException {
        this.buffer.close();
    }
}

