/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Certificate;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketBuilder;
import org.simpleframework.transport.PacketController;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketController;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

public class SocketTransport
implements Transport {
    private PacketController writer;
    private PacketBuilder builder;
    private SocketChannel channel;
    private Socket socket;
    private Trace trace;
    private boolean closed;

    public SocketTransport(Socket socket, Reactor reactor) throws IOException {
        this(socket, reactor, 20480);
    }

    public SocketTransport(Socket socket, Reactor reactor, int threshold) throws IOException {
        this(socket, reactor, threshold, 3);
    }

    public SocketTransport(Socket socket, Reactor reactor, int threshold, int queue) throws IOException {
        this(socket, reactor, threshold, queue, 4096);
    }

    public SocketTransport(Socket socket, Reactor reactor, int threshold, int queue, int buffer) throws IOException {
        this.writer = new SocketController(socket, reactor, threshold);
        this.builder = new PacketBuilder(queue, buffer);
        this.channel = socket.getChannel();
        this.trace = socket.getTrace();
        this.socket = socket;
    }

    public Certificate getCertificate() {
        return null;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Map getAttributes() {
        return this.socket.getAttributes();
    }

    public SSLEngine getEngine() {
        return this.socket.getEngine();
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public int read(ByteBuffer data) throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        int count = this.channel.read(data);
        if (this.trace != null) {
            this.trace.trace((Object)TransportEvent.READ, count);
        }
        return count;
    }

    public void write(ByteBuffer data) throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        Packet packet = this.builder.build(data);
        while (packet != null) {
            if (!this.closed) {
                this.writer.write(packet);
            }
            packet = this.builder.build(data);
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        Packet packet = this.builder.build();
        if (packet != null) {
            this.writer.write(packet);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            Packet packet = this.builder.build();
            if (packet != null) {
                this.writer.write(packet);
            }
            this.writer.close();
            this.closed = true;
        }
    }
}

