/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport;

import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.AsyncResponse;

public class AsyncResponseImpl
implements AsyncResponse {
    @NotNull
    private final Future<?> future;
    @Nullable
    private Runnable successHandler;
    @Nullable
    private AsyncResponse.ExceptionConsumer errorHandler;
    @Nullable
    private Exception delegatedException;

    AsyncResponseImpl(@NotNull Future<?> future) {
        this.future = future;
    }

    public void onSuccess(@NotNull Runnable onSuccess) {
        this.successHandler = onSuccess;
        if (this.future.isDone() && this.delegatedException == null) {
            this.successHandler.run();
        }
    }

    public void onException(@NotNull AsyncResponse.ExceptionConsumer errorHandler) {
        this.errorHandler = errorHandler;
        if (this.future.isDone() && this.delegatedException != null) {
            errorHandler.accept(this.delegatedException);
        }
    }

    void delegateSuccessHandling() {
        if (this.successHandler != null) {
            this.successHandler.run();
        }
    }

    void delegateExceptionHandling(Exception e) {
        this.delegatedException = e;
        if (this.errorHandler != null) {
            this.errorHandler.accept(e);
        }
    }

    @NotNull
    public Future<?> getFuture() {
        return this.future;
    }
}

