/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public final class JSONCompare {
    private JSONCompare() {
    }

    private static JSONComparator getComparatorForMode(JSONCompareMode mode) {
        return new DefaultComparator(mode);
    }

    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        Object actual = JSONParser.parseJSON(actualStr);
        if (expected instanceof JSONObject && actual instanceof JSONObject) {
            return JSONCompare.compareJSON((JSONObject)expected, (JSONObject)actual, comparator);
        }
        if (expected instanceof JSONArray && actual instanceof JSONArray) {
            return JSONCompare.compareJSON((JSONArray)expected, (JSONArray)actual, comparator);
        }
        if (expected instanceof JSONObject) {
            return new JSONCompareResult().fail("", expected, actual);
        }
        return new JSONCompareResult().fail("", expected, actual);
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONComparator comparator) throws JSONException {
        return comparator.compareJSON(expected, actual);
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONComparator comparator) throws JSONException {
        return comparator.compareJSON(expected, actual);
    }

    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONCompareMode mode) throws JSONException {
        return JSONCompare.compareJSON(expectedStr, actualStr, JSONCompare.getComparatorForMode(mode));
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONCompareMode mode) throws JSONException {
        return JSONCompare.compareJSON(expected, actual, JSONCompare.getComparatorForMode(mode));
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONCompareMode mode) throws JSONException {
        return JSONCompare.compareJSON(expected, actual, JSONCompare.getComparatorForMode(mode));
    }
}

