/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.reload4j;

import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.MDC;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class Reload4jMDCAdapter
implements MDCAdapter {
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    public void clear() {
        Hashtable map = MDC.getContext();
        if (map != null) {
            map.clear();
        }
    }

    public String get(String key) {
        return (String)MDC.get((String)key);
    }

    public void put(String key, String val) {
        MDC.put((String)key, (Object)val);
    }

    public void remove(String key) {
        MDC.remove((String)key);
    }

    public Map getCopyOfContextMap() {
        Hashtable old = MDC.getContext();
        if (old != null) {
            return new HashMap(old);
        }
        return null;
    }

    public void setContextMap(Map<String, String> contextMap) {
        Hashtable old = MDC.getContext();
        if (contextMap == null) {
            if (old != null) {
                old.clear();
            }
            return;
        }
        if (old == null) {
            for (Map.Entry<String, String> mapEntry : contextMap.entrySet()) {
                MDC.put((String)mapEntry.getKey(), mapEntry);
            }
        } else {
            old.clear();
            old.putAll(contextMap);
        }
    }

    public void pushByKey(String key, String value) {
        this.threadLocalMapOfDeques.pushByKey(key, value);
    }

    public String popByKey(String key) {
        return this.threadLocalMapOfDeques.popByKey(key);
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(key);
    }

    public void clearDequeByKey(String key) {
        this.threadLocalMapOfDeques.clearDequeByKey(key);
    }
}

